/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.hdfs;

import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.internal.hdfs.HdfsOpContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsGetFileChecksumOp {
    static final Logger LOG = LoggerFactory.getLogger(HdfsGetFileChecksumOp.class);
    private final HdfsOpContext context;
    private final FileSystem fs;
    private final CredentialContext ossContext;

    public HdfsGetFileChecksumOp(HdfsOpContext context, FileSystem fs, CredentialContext ossContext) {
        this.context = context;
        this.fs = fs;
        this.ossContext = ossContext;
    }

    public String getFileChecksum(Path f, CredentialContext ossContext) throws IOException {
        try {
            return this.context.hdfsFileletSystem.getFileChecksum(new JindoRequestPath(f.toString(), ossContext));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

