/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.oss.commit;

import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.oss.commit.magic.JindoOssMagicCommitter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoOssMapredCommitter
extends FileOutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(JindoOssMapredCommitter.class);
    private org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter wrapped = null;

    private org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter getWrapped(org.apache.hadoop.mapred.JobContext context) throws IOException {
        if (this.wrapped == null) {
            if (this.useMagicCommitter(JindoOssMapredCommitter.getOutputPath(context), context.getConfiguration())) {
                this.wrapped = new JindoOssMagicCommitter(JindoOssMapredCommitter.getOutputPath(context), (JobContext)context);
                LOG.info("Using JindoOssMagicCommitter as Job Committer.");
            } else {
                this.wrapped = new org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter(JindoOssMapredCommitter.getOutputPath(context), (JobContext)context);
                LOG.info("Using FileOutputCommitter as Job Committer.");
            }
        }
        return this.wrapped;
    }

    private org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter getWrapped(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        if (this.wrapped == null) {
            if (this.useMagicCommitter(JindoOssMapredCommitter.getOutputPath(context), context.getConfiguration())) {
                this.wrapped = new JindoOssMagicCommitter(JindoOssMapredCommitter.getOutputPath(context), (TaskAttemptContext)context);
                LOG.info("Using JindoOssMagicCommitter as Job Committer.");
            } else {
                this.wrapped = new org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter(JindoOssMapredCommitter.getOutputPath(context), (TaskAttemptContext)context);
                LOG.info("Using FileOutputCommitter as Job Committer.");
            }
        }
        return this.wrapped;
    }

    public void setupJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        this.getWrapped(jobContext).setupJob((JobContext)jobContext);
    }

    public void abortJob(org.apache.hadoop.mapred.JobContext jobContext, int runState) throws IOException {
        JobStatus.State state;
        if (runState == JobStatus.State.RUNNING.getValue()) {
            state = JobStatus.State.RUNNING;
        } else if (runState == JobStatus.State.SUCCEEDED.getValue()) {
            state = JobStatus.State.SUCCEEDED;
        } else if (runState == JobStatus.State.FAILED.getValue()) {
            state = JobStatus.State.FAILED;
        } else if (runState == JobStatus.State.PREP.getValue()) {
            state = JobStatus.State.PREP;
        } else {
            if (runState != JobStatus.State.KILLED.getValue()) {
                throw new IllegalArgumentException(runState + " is not a valid runState.");
            }
            state = JobStatus.State.KILLED;
        }
        this.getWrapped(jobContext).abortJob((JobContext)jobContext, state);
    }

    private static Path getOutputPath(org.apache.hadoop.mapred.JobContext context) {
        JobConf conf = context.getJobConf();
        return FileOutputFormat.getOutputPath((JobConf)conf);
    }

    private static Path getOutputPath(org.apache.hadoop.mapred.TaskAttemptContext context) {
        JobConf conf = context.getJobConf();
        return FileOutputFormat.getOutputPath((JobConf)conf);
    }

    public void cleanupJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        this.getWrapped(jobContext).cleanupJob((JobContext)jobContext);
    }

    public void commitJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        this.getWrapped(jobContext).commitJob((JobContext)jobContext);
    }

    public void setupTask(org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext) throws IOException {
        this.getWrapped(taskAttemptContext).setupTask((TaskAttemptContext)taskAttemptContext);
    }

    public boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext) throws IOException {
        return this.getWrapped(taskAttemptContext).needsTaskCommit((TaskAttemptContext)taskAttemptContext);
    }

    public void commitTask(org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext) throws IOException {
        this.getWrapped(taskAttemptContext).commitTask((TaskAttemptContext)taskAttemptContext);
    }

    public void abortTask(org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext) throws IOException {
        this.getWrapped(taskAttemptContext).abortTask((TaskAttemptContext)taskAttemptContext);
    }

    public void recoverTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
        this.getWrapped(taskContext).recoverTask((TaskAttemptContext)taskContext);
    }

    public boolean isRecoverySupported() {
        if (this.wrapped == null) {
            return false;
        }
        return this.wrapped.isRecoverySupported();
    }

    public boolean isRecoverySupported(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        return this.getWrapped(jobContext).isRecoverySupported((JobContext)jobContext);
    }

    public boolean isCommitJobRepeatable(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        return this.getWrapped(jobContext).isCommitJobRepeatable((JobContext)jobContext);
    }

    public Path getWorkPath(org.apache.hadoop.mapred.TaskAttemptContext context, Path outputPath) throws IOException {
        return this.getWrapped(context).getWorkPath();
    }

    private boolean useMagicCommitter(Path outputPath, Configuration conf) throws IOException {
        if (outputPath == null) {
            return false;
        }
        FileSystem fs = outputPath.getFileSystem(conf);
        if (fs instanceof AbstractJindoShimsFileSystem) {
            return ((AbstractJindoShimsFileSystem)fs).isMagicCommitEnabled();
        }
        return false;
    }
}

