/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.oss.commit.magic;

import com.aliyun.emr.fs.oss.commit.magic.CommitUtils;
import com.aliyun.emr.fs.oss.commit.magic.PersistentCommitData;
import com.aliyun.emr.fs.oss.commit.magic.SinglePendingCommit;
import com.aliyun.emr.fs.oss.commit.magic.ValidationFailure;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PendingSet
extends PersistentCommitData {
    private static final Logger LOG = LoggerFactory.getLogger(PendingSet.class);
    public static final int VERSION = 1;
    private static final long serialVersionUID = 69633L;
    private int version = 1;
    private List<SinglePendingCommit> commits;
    private final Map<String, String> extraData = new HashMap<String, String>(0);

    public PendingSet() {
        this(0);
    }

    public PendingSet(int size) {
        this.commits = new ArrayList<SinglePendingCommit>(size);
    }

    public static PendingSet load(FileSystem fs, Path path) throws IOException {
        LOG.debug("Reading pending commits in file {}", (Object)path);
        PendingSet instance = new PendingSet();
        try (FSDataInputStream dataInputStream = fs.open(path);){
            instance.version = dataInputStream.readInt();
            int commitSize = dataInputStream.readInt();
            ArrayList<SinglePendingCommit> commits = new ArrayList<SinglePendingCommit>(commitSize);
            for (int i = 0; i < commitSize; ++i) {
                byte[] commitBytes = CommitUtils.readBytesFromInputStream((DataInputStream)dataInputStream);
                commits.add(SinglePendingCommit.fromBytes(commitBytes));
            }
            instance.commits = commits;
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize PendingSet.", (Throwable)e);
            throw e;
        }
        instance.validate();
        return instance;
    }

    public void add(SinglePendingCommit commit) {
        this.commits.add(commit);
    }

    @Override
    public void validate() throws ValidationFailure {
        ValidationFailure.verify(this.version == 1, "Wrong version: %s", this.version);
        CommitUtils.validateCollectionClass(this.extraData.keySet(), String.class);
        CommitUtils.validateCollectionClass(this.extraData.values(), String.class);
        HashSet<String> destinations = new HashSet<String>(this.commits.size());
        CommitUtils.validateCollectionClass(this.commits, SinglePendingCommit.class);
        for (SinglePendingCommit c : this.commits) {
            c.validate();
            ValidationFailure.verify(!destinations.contains(c.getDestinationKey()), "Destination %s is written to by more than one pending commit", c.getDestinationKey());
            destinations.add(c.getDestinationKey());
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(this.version);
            int commitSize = this.commits != null ? this.commits.size() : 0;
            dataOutputStream.writeInt(commitSize);
            for (int i = 0; i < commitSize; ++i) {
                byte[] bytes = this.commits.get(i).toBytes();
                CommitUtils.writeBytesToOutputStream(dataOutputStream, bytes);
            }
            dataOutputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOG.error("Failed to serialize PendingSet.", (Throwable)e);
            throw e;
        }
        finally {
            try {
                dataOutputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close OutputStream.", (Throwable)e);
            }
        }
    }

    public int size() {
        return this.commits != null ? this.commits.size() : 0;
    }

    @Override
    public void save(FileSystem fs, Path path, boolean overwrite) throws IOException {
        try (FSDataOutputStream outputStream = fs.create(path, overwrite);){
            outputStream.write(this.toBytes());
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public List<SinglePendingCommit> getCommits() {
        return this.commits;
    }

    public void setCommits(List<SinglePendingCommit> commits) {
        this.commits = commits;
    }
}

