/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth.delegation;

import com.aliyun.emr.fs.common.DurationInfo;
import com.aliyun.emr.fs.s3.auth.S3CredentialProviderList;
import com.aliyun.emr.fs.s3.auth.delegation.AbstractDTService;
import com.aliyun.emr.fs.s3.auth.delegation.AbstractDelegationTokenBinding;
import com.aliyun.emr.fs.s3.auth.delegation.AbstractS3TokenIdentifier;
import com.aliyun.emr.fs.s3.auth.delegation.DelegationTokenIOException;
import com.aliyun.emr.fs.s3.auth.delegation.FullCredentialsTokenBinding;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class S3DelegationTokens
extends AbstractDTService {
    private static final Logger LOG = LoggerFactory.getLogger(S3DelegationTokens.class);
    @VisibleForTesting
    static final String E_ALREADY_DEPLOYED = "S3 Delegation tokens has already been bound/deployed";
    public static final String E_DELEGATION_TOKENS_DISABLED = "Delegation tokens are not enabled";
    private final UserGroupInformation user;
    private final AtomicInteger creationCount = new AtomicInteger(0);
    private Text service;
    private Optional<Token<AbstractS3TokenIdentifier>> boundDT = Optional.empty();
    private Optional<AbstractS3TokenIdentifier> decodedIdentifier = Optional.empty();
    private AbstractDelegationTokenBinding tokenBinding;
    private Optional<S3CredentialProviderList> credentialProviders = Optional.empty();
    private String tokenBindingName = "";

    public S3DelegationTokens() throws IOException {
        super("S3DelegationTokens");
        this.user = UserGroupInformation.getCurrentUser();
    }

    @Override
    public void bindToFileSystem(URI uri, UserGroupInformation owner) throws IOException {
        super.bindToFileSystem(uri, owner);
        this.service = S3DelegationTokens.getTokenService(this.getCanonicalUri());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        Preconditions.checkState(S3DelegationTokens.hasDelegationTokenBinding(conf), E_DELEGATION_TOKENS_DISABLED);
        Class binding = conf.getClass("fs.jfs.cache.delegation.token.binding", FullCredentialsTokenBinding.class, AbstractDelegationTokenBinding.class);
        this.tokenBinding = (AbstractDelegationTokenBinding)((Object)binding.newInstance());
        this.tokenBinding.bindToFileSystem(this.getCanonicalUri(), this.getOwner());
        this.tokenBinding.init(conf);
        this.tokenBindingName = this.tokenBinding.getKind().toString();
        LOG.debug("Filesystem {} is using delegation tokens of kind {}", (Object)this.getCanonicalUri(), (Object)this.tokenBindingName);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.tokenBinding.start();
        this.bindToAnyDelegationToken();
        LOG.debug("S3 Delegation support token {} with {}", (Object)this.identifierToString(), (Object)this.tokenBinding.getDescription());
    }

    private String identifierToString() {
        return this.decodedIdentifier.map(Objects::toString).orElse("(none)");
    }

    protected void serviceStop() throws Exception {
        LOG.debug("Stopping delegation tokens");
        try {
            super.serviceStop();
        }
        finally {
            ServiceOperations.stopQuietly((Service)this.tokenBinding);
        }
    }

    private void deployUnbonded() throws IOException {
        this.requireServiceStarted();
        Preconditions.checkState(!this.isBoundToDT(), "Already Bound to a delegation token");
        LOG.debug("No delegation tokens present: using direct authentication");
        this.credentialProviders = Optional.of(this.tokenBinding.deployUnbonded());
    }

    private void bindToAnyDelegationToken() throws IOException {
        Preconditions.checkState(!this.credentialProviders.isPresent(), E_ALREADY_DEPLOYED);
        Token<AbstractS3TokenIdentifier> token = this.selectTokenFromFSOwner();
        if (token != null) {
            this.bindToDelegationToken(token);
        } else {
            this.deployUnbonded();
        }
        if (this.credentialProviders.get().size() == 0) {
            throw new DelegationTokenIOException("No credential providers created by Delegation Token Binding " + this.tokenBinding.getName());
        }
    }

    @VisibleForTesting
    void resetTokenBindingToDT(Token<AbstractS3TokenIdentifier> token) throws IOException {
        this.credentialProviders = Optional.empty();
        this.bindToDelegationToken(token);
    }

    @VisibleForTesting
    public void bindToDelegationToken(Token<AbstractS3TokenIdentifier> token) throws IOException {
        Preconditions.checkState(!this.credentialProviders.isPresent(), E_ALREADY_DEPLOYED);
        this.boundDT = Optional.of(token);
        AbstractS3TokenIdentifier dti = this.extractIdentifier(token);
        LOG.info("Using delegation token {}", (Object)dti);
        this.decodedIdentifier = Optional.of(dti);
        try (DurationInfo ignored = new DurationInfo(LOG, true, "Creating Delegation Token", new Object[0]);){
            this.credentialProviders = Optional.of(this.tokenBinding.bindToTokenIdentifier(dti));
        }
    }

    public boolean isBoundToDT() {
        return this.boundDT.isPresent();
    }

    public Optional<Token<AbstractS3TokenIdentifier>> getBoundDT() {
        return this.boundDT;
    }

    public TokenIssuingPolicy getTokenIssuingPolicy() {
        return this.isBoundToDT() ? TokenIssuingPolicy.ReturnExistingToken : this.tokenBinding.getTokenIssuingPolicy();
    }

    public Token<AbstractS3TokenIdentifier> getBoundOrNewDT(Text renewer) throws IOException {
        LOG.debug("Delegation token requested");
        if (this.isBoundToDT()) {
            LOG.debug("Returning current token");
            return this.getBoundDT().get();
        }
        return this.createDelegationToken(renewer);
    }

    public int getCreationCount() {
        return this.creationCount.get();
    }

    @VisibleForTesting
    public Token<AbstractS3TokenIdentifier> createDelegationToken(Text renewer) throws IOException {
        this.requireServiceStarted();
        try (DurationInfo ignored = new DurationInfo(LOG, true, "Creating New Delegation Token", this.tokenBinding.getKind());){
            Token<AbstractS3TokenIdentifier> token = this.tokenBinding.createDelegationToken(renewer);
            if (token != null) {
                token.setService(this.service);
                this.noteTokenCreated(token);
            }
            Token<AbstractS3TokenIdentifier> token2 = token;
            return token2;
        }
    }

    private void noteTokenCreated(Token<AbstractS3TokenIdentifier> token) {
        LOG.info("Created S3 Delegation Token: {}", token);
        this.creationCount.incrementAndGet();
    }

    public S3CredentialProviderList getCredentialProviders() throws IOException {
        return this.credentialProviders.orElseThrow(() -> new DelegationTokenIOException("Not yet bonded"));
    }

    public Optional<AbstractS3TokenIdentifier> getDecodedIdentifier() {
        return this.decodedIdentifier;
    }

    public Text getService() {
        return this.service;
    }

    public String getCanonicalServiceName() {
        return this.getCanonicalUri().toString();
    }

    @VisibleForTesting
    public Token<AbstractS3TokenIdentifier> selectTokenFromFSOwner() throws IOException {
        return S3DelegationTokens.lookupToken(this.user.getCredentials(), this.service, this.tokenBinding.getKind());
    }

    private static Text getTokenService(URI fsURI) {
        return S3DelegationTokens.getTokenService(fsURI.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3DelegationTokens{");
        sb.append("canonicalServiceURI=").append(this.getCanonicalUri());
        sb.append("; owner=").append(this.user.getShortUserName());
        sb.append("; isBoundToDT=").append(this.isBoundToDT());
        sb.append("; token creation count=").append(this.getCreationCount());
        sb.append("; tokenManager=").append((Object)this.tokenBinding);
        sb.append("; token=").append(this.identifierToString());
        sb.append('}');
        return sb.toString();
    }

    public Text getTokenKind() {
        return this.tokenBinding.getKind();
    }

    @VisibleForTesting
    static Text getTokenService(String fsURI) {
        return new Text(fsURI);
    }

    public AbstractS3TokenIdentifier extractIdentifier(Token<? extends AbstractS3TokenIdentifier> token) throws IOException {
        AbstractS3TokenIdentifier identifier;
        Preconditions.checkArgument(token != null, "null token");
        try {
            identifier = (AbstractS3TokenIdentifier)token.decodeIdentifier();
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw new DelegationTokenIOException("Decoding S3 token " + cause, cause);
            }
            throw e;
        }
        if (identifier == null) {
            throw new DelegationTokenIOException("Failed to unmarshall token for " + this.getCanonicalUri());
        }
        identifier.validate();
        return identifier;
    }

    public String getUserAgentField() {
        return this.tokenBinding.getUserAgentField();
    }

    @VisibleForTesting
    public static Token<AbstractS3TokenIdentifier> lookupToken(Credentials credentials, Text service, Text kind) throws DelegationTokenIOException {
        LOG.debug("Looking for token for service {} in credentials", (Object)service);
        Token token = credentials.getToken(service);
        if (token != null) {
            Text tokenKind = token.getKind();
            LOG.debug("Found token of kind {}", (Object)tokenKind);
            if (kind.equals((Object)tokenKind)) {
                return token;
            }
            throw new DelegationTokenIOException("Token mismatch: expected token for " + service + " of type " + kind + " but got a token of type " + tokenKind);
        }
        LOG.debug("No token for {} found", (Object)service);
        return null;
    }

    public static Token<AbstractS3TokenIdentifier> lookupToken(Credentials credentials, Text service) {
        return credentials.getToken(service);
    }

    public static Token<AbstractS3TokenIdentifier> lookupS3DelegationToken(Credentials credentials, URI uri) {
        return S3DelegationTokens.lookupToken(credentials, S3DelegationTokens.getTokenService(uri.toString()));
    }

    public static boolean hasDelegationTokenBinding(Configuration conf) {
        return StringUtils.isNotEmpty(conf.getTrimmed("fs.jfs.cache.delegation.token.binding", ""));
    }

    public static enum TokenIssuingPolicy {
        ReturnExistingToken,
        NoTokensAvailable,
        RequestNewToken;

    }
}

