/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.s3.internal.s3native.S3OpContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DeleteOp {
    static final Logger LOG = LoggerFactory.getLogger(S3DeleteOp.class);
    private final S3OpContext context;
    private final FileSystem fs;
    private final CredentialContext s3Context;

    public S3DeleteOp(S3OpContext context, FileSystem fs, CredentialContext s3Context) {
        this.context = context;
        this.fs = fs;
        this.s3Context = s3Context;
    }

    public boolean delete(Path f, CredentialContext s3Context) throws IOException {
        return this.delete(f, true, false, s3Context);
    }

    public boolean delete(Path f, boolean recurse, boolean deleteWithVersions, CredentialContext s3Context) throws IOException {
        try {
            return this.context.s3FileletSystem.delete(new JindoRequestPath(f.toString(), s3Context), recurse, deleteWithVersions);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }
}

