/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.FileletXattributeList;
import bigboot.protocol.type.InodeStatus;
import bigboot.protocol.type.Xattribute;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;

public class S3FileStatus
extends FileStatus {
    static FsPermission nullPermission = null;
    private String jindoINodeId;
    private Map<String, String> attrs;
    String etag;
    String storageClass;
    String restoreStatus;

    public S3FileStatus(FileletStatus f, Configuration conf) {
        this(f.inodeAsInodeStatus(), conf);
        this.restoreStatus = this.convertS3RestoreStatus(f.restoreStatus());
    }

    private S3FileStatus(InodeStatus s, Configuration conf) {
        super(s.fileSize(), 0 == s.fileType(), 1, conf.getLong("fs.jfs.cache.s3-blocksize", 0x8000000L), s.mtime(), System.currentTimeMillis(), nullPermission, s.owner(), s.ownerGroup(), null, new Path(s.fileName()));
        this.jindoINodeId = s.fileId() == null ? "" : s.fileId();
        this.etag = s.etag();
        this.storageClass = this.convertS3StorageClass(s.storagePolicy());
    }

    private S3FileStatus(boolean isDir, short replication, Configuration conf) {
        super(0L, isDir, (int)replication, conf.getLong("fs.jfs.cache.s3-blocksize", 0x8000000L), System.currentTimeMillis(), 0L, null, null, null, null);
    }

    public static S3FileStatus createStatus(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Map<String, String> attrs, Configuration conf) {
        S3FileStatus status = S3FileStatus.createStatusInner(f, false, replication, conf);
        status.setPermission(permission);
        status.setAttrs(attrs);
        return status;
    }

    public static S3FileStatus createStatus(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Configuration conf) {
        S3FileStatus status = S3FileStatus.createStatusInner(f, false, replication, conf);
        status.setPermission(permission);
        return status;
    }

    public static S3FileStatus createStatusForDir(Path f, Configuration conf) {
        S3FileStatus status = S3FileStatus.createStatusInner(f, true, (short)0, conf);
        return status;
    }

    private static S3FileStatus createStatusInner(Path f, boolean isDir, short replication, Configuration conf) {
        String group;
        String user;
        S3FileStatus status = new S3FileStatus(isDir, replication, conf);
        try {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (Exception e) {
            user = "s3";
        }
        try {
            group = UserGroupInformation.getCurrentUser().getPrimaryGroupName();
        }
        catch (Exception e) {
            group = user;
        }
        status.setOwner(user);
        status.setGroup(group);
        status.setPath(f);
        return status;
    }

    public static ByteBuffer toBuffer(S3FileStatus status) {
        int attrOffset;
        FlatBufferBuilder builder = new FlatBufferBuilder();
        Map<String, String> attrs = status.getAttrs();
        if (attrs != null && !attrs.isEmpty()) {
            int size = attrs.size();
            int[] xattrOffsets = new int[size];
            FlatBufferBuilder xattrBuilder = new FlatBufferBuilder();
            int i = 0;
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                int nameOffset = xattrBuilder.createString(entry.getKey());
                int valueOffset = xattrBuilder.createString(entry.getValue());
                xattrOffsets[i] = Xattribute.createXattribute(xattrBuilder, nameOffset, valueOffset, (byte)0);
                ++i;
            }
            int xattrListOffset = xattrBuilder.createVectorOfTables(xattrOffsets);
            FileletXattributeList.startFileletXattributeList(xattrBuilder);
            FileletXattributeList.addXattributes(xattrBuilder, xattrListOffset);
            xattrBuilder.finish(FileletXattributeList.endFileletXattributeList(xattrBuilder));
            attrOffset = builder.createString(xattrBuilder.dataBuffer());
        } else {
            attrOffset = builder.createString("");
        }
        FlatBufferBuilder inodeBuilder = new FlatBufferBuilder();
        String idStr = status.getINodeId() != null ? status.getINodeId() : "";
        int idOffset = inodeBuilder.createString(idStr);
        int ownerOffset = inodeBuilder.createString(status.getOwner());
        int groupOffset = inodeBuilder.createString(status.getGroup());
        int fileNameOffset = inodeBuilder.createString("");
        int etagOffset = inodeBuilder.createString("");
        int locateOffset = inodeBuilder.createString("");
        int pidOffset = inodeBuilder.createString("");
        InodeStatus.startInodeStatus(inodeBuilder);
        InodeStatus.addFileType(inodeBuilder, status.isDirectory() ? (byte)0 : 1);
        InodeStatus.addFileId(inodeBuilder, idOffset);
        InodeStatus.addFileName(inodeBuilder, fileNameOffset);
        InodeStatus.addAttributes(inodeBuilder, attrOffset);
        InodeStatus.addParentId(inodeBuilder, pidOffset);
        InodeStatus.addOwner(inodeBuilder, ownerOffset);
        InodeStatus.addOwnerGroup(inodeBuilder, groupOffset);
        InodeStatus.addFileSize(inodeBuilder, status.getLen());
        InodeStatus.addMtime(inodeBuilder, status.getModificationTime());
        InodeStatus.addDirectChildrenLoaded(inodeBuilder, false);
        InodeStatus.addEtag(inodeBuilder, etagOffset);
        if (status.isDirectory()) {
            InodeStatus.addState(inodeBuilder, (byte)2);
        } else {
            InodeStatus.addState(inodeBuilder, (byte)1);
        }
        inodeBuilder.finish(InodeStatus.endInodeStatus(inodeBuilder));
        int inodeOff = builder.createString(inodeBuilder.dataBuffer());
        FileletStatus.startFileletStatus(builder);
        FileletStatus.addLocations(builder, locateOffset);
        FileletStatus.addInode(builder, inodeOff);
        builder.finish(FileletStatus.endFileletStatus(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }

    public String getINodeId() {
        return this.jindoINodeId;
    }

    public void setINodeId(String jindoINodeId) {
        this.jindoINodeId = jindoINodeId;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getRestoreStatus() {
        return this.restoreStatus;
    }

    public void setAttrs(Map<String, String> attrs) {
        this.attrs = attrs;
    }

    public Map<String, String> getAttrs() {
        return this.attrs;
    }

    public String convertS3StorageClass(byte storagePolicy) {
        if (1 == storagePolicy) {
            return "Archive";
        }
        if (2 == storagePolicy) {
            return "InfrequentAccess";
        }
        if (4 == storagePolicy) {
            return "Standard";
        }
        if (9 == storagePolicy) {
            return "ColdArchive";
        }
        return "Unknown";
    }

    public String convertS3RestoreStatus(byte restoreStatus) {
        if (0 == restoreStatus) {
            return "Unknown";
        }
        if (1 == restoreStatus) {
            return "Restoring";
        }
        if (2 == restoreStatus) {
            return "Completed";
        }
        return "Unknown";
    }
}

