/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import com.aliyun.emr.fs.jfs.JindoFileSystem;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.FsCommandProvider;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.StringUtils;

public class JfsChecksum
implements FsCommandProvider {
    @Override
    public Class<? extends FsCommand> getCommandClass() {
        return Display.class;
    }

    public static class Display
    extends FsCommand {
        public static void registerCommands(CommandFactory factory) {
            factory.addClass(Checksum.class, new String[]{"-checksum"});
        }

        public static class Checksum
        extends Display {
            public static final String NAME = "checksum";
            public static final String USAGE = "<src> ...";
            public static final String DESCRIPTION = "Dump checksum information for files that match the file pattern <src> to stdout. Note that this requires a round-trip to a datanode storing each block of the file, and thus is not efficient to run on a large number of files. The checksum of a file depends on its content, block size and the checksum algorithm and parameters used for creating the file.\n\nFor JindoFS only, block size can be configured for MD5 CRC algorithm\n  -b blockSize  Block size for computing MD5 CRC.";
            private long blockSize = 0x8000000L;

            protected void processOptions(LinkedList<String> args) throws IOException {
                String v = StringUtils.popOptionWithArgument((String)"-b", args);
                if (v != null) {
                    this.blockSize = Long.parseLong(v);
                }
            }

            protected void processPath(PathData item) throws IOException {
                if (item.stat.isDirectory()) {
                    throw new PathIsDirectoryException(item.toString());
                }
                FileChecksum checksum = null;
                if (item.fs instanceof JindoFileSystem) {
                    JindoFileSystem jfs = (JindoFileSystem)item.fs;
                    checksum = jfs.getFileChecksum2(item.path, this.blockSize);
                } else {
                    checksum = item.fs.getFileChecksum(item.path);
                }
                if (checksum == null) {
                    this.out.printf("%s\tNONE\t%n", item.toString());
                } else {
                    String checksumString = StringUtils.byteToHexString((byte[])checksum.getBytes(), (int)0, (int)checksum.getLength());
                    this.out.printf("%s\t%s\t%s%n", item.toString(), checksum.getAlgorithmName(), checksumString);
                }
            }
        }
    }
}

