package utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 日期时间工具类
 * @Author 	zhenxin.ma
 * @Date 	2019/8/29 17:28
 * @Version 1.0
 */
public class DateUtils {
	public static final SimpleDateFormat TIME_FORMAT =
			new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	public static final SimpleDateFormat DATE_FORMAT =
			new SimpleDateFormat("yyyy-MM-dd");
	public static ThreadLocal<SimpleDateFormat> simpleDateFormatThreadLocal=new ThreadLocal<SimpleDateFormat>(){
		@Override
		protected SimpleDateFormat initialValue() {
			return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		}
	};

	/**
	 * 判断一个时间是否在另一个时间之前
	 * @param time1 第一个时间
	 * @param time2 第二个时间
	 * @return 判断结果
	 */
	public static boolean before(String time1, String time2) {
		try {
			Date dateTime1 = TIME_FORMAT.parse(time1);
			Date dateTime2 = TIME_FORMAT.parse(time2);

			if(dateTime1.before(dateTime2)) {
				return true;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	/**
	 * 判断一个时间是否在另一个时间之后
	 * @param time1 第一个时间
	 * @param time2 第二个时间
	 * @return 判断结果
	 */
	public static boolean after(String time1, String time2) {
		try {
			Date dateTime1 = TIME_FORMAT.parse(time1);
			Date dateTime2 = TIME_FORMAT.parse(time2);

			if(dateTime1.after(dateTime2)) {
				return true;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}


	/**
	 * 计算时间差值（单位为秒）
	 * @param time1 时间1
	 * @param time2 时间2
	 * @return 差值
	 */
	public static int minus(String time1, String time2) {
		try {
			Date datetime1 = TIME_FORMAT.parse(time1);
			Date datetime2 = TIME_FORMAT.parse(time2);

			long millisecond = datetime1.getTime() - datetime2.getTime();

			return Integer.valueOf(String.valueOf(millisecond / 1000));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return 0;
	}

	/**
	 * 获取年月日和小时
	 * @param datetime 时间（yyyy-MM-dd HH:mm:ss）
	 * @return 结果
	 */
	public static String getDateHour(String datetime) {
		String date = datetime.split(" ")[0];
		String hourMinuteSecond = datetime.split(" ")[1];
		String hour = hourMinuteSecond.split(":")[0];
		return date + "_" + hour;
	}



	/**
	 * @Description 毫秒转换成标准时间 yyyy-MM-dd HH:mm:ss
	 * @param time 传入的参数,毫秒时间
	 * @return java.lang.String
	 **/
	public static String milliSecondsFormatTime(String time){
		if (time == null || time.isEmpty()) {
			return "";
		}
		Date tmpDate = new Date();
		tmpDate.setTime(Long.parseLong(time));
		String dtime = simpleDateFormatThreadLocal.get().format(tmpDate);
		return dtime;
	}


	/**
	 * 获取昨天的日期（yyyy-MM-dd）
	 * @return 昨天的日期
	 */
	public static String getYesterdayDate() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.add(Calendar.DAY_OF_YEAR, -1);

		Date date = cal.getTime();

		return DATE_FORMAT.format(date);
	}

	/**
	 * 获取当天日期（yyyy-MM-dd）
	 * @return 当天日期
	 */
	public static String getTodayDate() {
		return DATE_FORMAT.format(new Date());
	}



	/**
	 * @Description 获取当天的时间:yyyy-MM-dd HH:mm:ss
	 * @param
	 * @return java.lang.String
	 **/
	public static String getTodayTime() {
		return simpleDateFormatThreadLocal.get().format(new Date());
	}


//	/**
//	 * @Description		获取昨天的日期:yyyy-MM-dd HH:mm:ss
//	 * @param gapDay
//	 * @return java.lang.String
//	 **/
//	public static String getYesterdayTime(int gapDay){
//		Calendar calendar=Calendar.getInstance();
//		calendar.set(Calendar.HOUR_OF_DAY,24*gapDay);
//		String yesterdayDate=simpleDateFormatThreadLocal.get().format(calendar.getTime());
//		return  yesterdayDate;
//	}


	/**
	 * 格式化日期（yyyy-MM-dd）
	 * @param date Date对象
	 * @return 格式化后的日期
	 */
	public static String formatDate(Date date) {
		return DATE_FORMAT.format(date);
	}

	/**
	 * 格式化时间（yyyy-MM-dd HH:mm:ss）
	 * @param date Date对象
	 * @return 格式化后的时间
	 */
	public static String formatTime(Date date) {
		return TIME_FORMAT.format(date);
	}


	/**
	 * @Description		日期解析
	 * @param time		格式化的时间(yyyy-MM-dd HH:mm:ss)
	 * @return java.util.Date
	 **/
	public static Date parseTime(String time)
	{
		try {
			Date result=simpleDateFormatThreadLocal.get().parse(time);
			simpleDateFormatThreadLocal.remove();
			return result;
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}


	public static void main(String[] args) {
		final Date date = new Date();
		System.out.println(date);
		System.out.println(parseTime("2020-03-30 11:45:18"));
		System.out.println(formatDate(date));
		System.out.println(formatTime(date));
		System.out.println(getYesterdayDate());

		String com = "005#";
		final String[] strs = com.split("#");
		System.out.println("length is "+strs.length);
		System.out.println("0位数据是: "+strs[0]);
	}

}

