// import fetch from '@/utils/fetch';
// import { getBaseUrl } from '@/utils/index'
// import { setCookie, getCookie, delCookie } from '@/utils/index';
// import { envConfig } from '@/utils/env-config';

const question = {
  state: {
    dataType: 0,
    freeFlag: 0,
    bindStatus: 0,            // 绑卡状态：0未绑卡 1已绑卡
    questionList: [],
    currentQuestion: {
      order: 1,
      isAnalyzed: false,
      options: [         // 从options加工出来
        {
          isCorrect: false,
          isSelected: true,
          text: "进行分析评估",
        },
        {
          isCorrect: false,
          isSelected: false,
          text: "进行分析评估",
        },
        {
          isCorrect: true,
          isSelected: true,
          text: "进行分析评估",
        },
        {
          isCorrect: false,
          isSelected: false,
          text: "进行分析评估",
        },
      ],
      titleId: 1,
      titleNo: 1,           // 题序，从1开始
      typeId: 1,            // 题目类型ID 1-单选，2-多选，3-判断
      unionId: "",          // 联合类型题目，分组唯一标识
      unionType: 1,         // 0普通题型 1-共用题干； 2-共用选项
      unionQuestion: "",    // 共用题干
      question: "题干内容",   // 题干内容
      config: "",           // 选项
      answer: "",           // 正确答案
      intro: "",            // 题目解析
      score: 0,             // 题目分值
      myAnswer: "",         // 我的答案
      commitFlag: 0,        // 0还未做 1做对了 2做错了
      favorFlag: 0,         // 0未收藏 1已收藏
      pictureFlag: "",      // 0没有图 1有图
      questionStreamType: "",   // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
      directoryId: 0,       // 题库ID
      paperId: "",          // 试卷ID
      paperIndex: "",       // 试卷索引
    },
    currentQuestionIndex: 0,
    totalCount: 30,
    resultId: 0,
    currentTitleNo: "",
    commitKind: 1,            // 答题来源 1：错题集 2：收藏 3：题库
  },
  mutations: {
    SET_DATA_TYPE: (state, payload) => {
      state.dataType = payload;
    },
    SET_FREE_FLAG: (state, payload) => {
      state.freeFlag = payload;
    },
    SET_QUESTION_LIST: (state, payload) => {
      state.questionList = payload;
    },
    SET_CURRENT_QUESTION: (state, payload) => {
      state.currentQuestion = payload;
    },
    SET_CURRENT_QUESTION_INDEX: (state, payload) => {
      state.currentQuestionIndex = payload;
    },
    SET_TOTAL_COUNT: (state, payload) => {
      state.totalCount = payload;
    },
  },
  actions: {
    // 获取用户信息
    async getQuestionList({ commit, state }, params) {
      console.log(params);
      let currentList = [
        {
          order: 1,
          isAnalyzed: false,
          options: [
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估",
            },
            {
              isCorrect: true,
              isSelected: false,
              text: "进行分析评估",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估",
            },
          ],
          titleId: 1,
          titleNo: 1,           // 题序，从1开始
          typeId: 1,            // 题目类型ID 1-单选，2-多选，3-判断
          unionId: "",          // 联合类型题目，分组唯一标识
          unionType: 0,         // 0普通题型 1-共用题干； 2-共用选项
          unionQuestion: "",    // 共用题干
          question: "题干内容",   // 题干内容
          config: "",           // 选项
          answer: "",           // 正确答案
          intro: "",            // 题目解析
          score: 0,             // 题目分值
          myAnswer: "",         // 我的答案
          commitFlag: 0,        // 0还未做 1做对了 2做错了
          favorFlag: 0,         // 0未收藏 1已收藏
          pictureFlag: "",      // 0没有图 1有图
          questionStreamType: "",   // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
          directoryId: 0,       // 题库ID
          paperId: "",          // 试卷ID
          paperIndex: "",       // 试卷索引
        },
        {
          order: 2,
          isAnalyzed: false,
          options: [
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估2",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估2",
            },
            {
              isCorrect: true,
              isSelected: false,
              text: "进行分析评估2",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评3",
            },
          ],
          titleId: 1,
          titleNo: 1,           // 题序，从1开始
          typeId: 1,            // 题目类型ID 1-单选，2-多选，3-判断
          unionId: "",          // 联合类型题目，分组唯一标识
          unionType: 2,         // 0普通题型 1-共用题干； 2-共用选项
          unionQuestion: "",    // 共用题干
          question: "题干内容",   // 题干内容
          config: "",           // 选项
          answer: "",           // 正确答案
          intro: "",            // 题目解析
          score: 0,             // 题目分值
          myAnswer: "",         // 我的答案
          commitFlag: 0,        // 0还未做 1做对了 2做错了
          favorFlag: 0,         // 0未收藏 1已收藏
          pictureFlag: "",      // 0没有图 1有图
          questionStreamType: "",   // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
          directoryId: 0,       // 题库ID
          paperId: "",          // 试卷ID
          paperIndex: "",       // 试卷索引
        },
        {
          order: 3,
          isAnalyzed: false,
          options: [
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估3",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估3",
            },
            {
              isCorrect: true,
              isSelected: false,
              text: "进行分析评估3",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估3",
            },
          ],
          question: "题干内容",   // 题干内容
          titleId: 1,           // 
          titleNo: 1,           // 题序，从1开始
          typeId: 1,            // 题目类型ID 1-单选，2-多选，3-判断
          unionId: "",          // 联合类型题目，分组唯一标识
          unionType: 1,         // 0普通题型 1-共用题干； 2-共用选项
          unionQuestion: "",    // 共用题干
          question: "题干内容",   // 题干内容
          config: "",           // 选项
          answer: "",           // 正确答案
          intro: "",            // 题目解析
          score: 0,             // 题目分值
          myAnswer: "",         // 我的答案
          commitFlag: 0,        // 0还未做 1做对了 2做错了
          favorFlag: 0,         // 0未收藏 1已收藏
          pictureFlag: "",      // 0没有图 1有图
          questionStreamType: "", // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
          directoryId: 0,       // 题库ID
          paperId: "",          // 试卷ID
          paperIndex: "",       // 试卷索引
        },
        {
          order: 4,
          isAnalyzed: false,
          options: [
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估4",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估4",
            },
            {
              isCorrect: true,
              isSelected: false,
              text: "进行分析评估4",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估4",
            },
          ],
          titleId: 1,
          titleNo: 1,           // 题序，从1开始
          typeId: 2,            // 题目类型ID 1-单选，2-多选，3-判断
          unionId: "",          // 联合类型题目，分组唯一标识
          unionType: 1,         // 0普通题型 1-共用题干； 2-共用选项
          unionQuestion: "",    // 共用题干
          question: "题干内容",  // 题干内容
          config: "",           // 选项
          answer: "",           // 正确答案
          intro: "",            // 题目解析
          score: 0,             // 题目分值
          myAnswer: "",         // 我的答案
          commitFlag: 0,        // 0还未做 1做对了 2做错了
          favorFlag: 0,         // 0未收藏 1已收藏
          pictureFlag: "",      // 0没有图 1有图
          questionStreamType: "",   // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
          directoryId: 0,       // 题库ID
          paperId: "",          // 试卷ID
          paperIndex: "",       // 试卷索引  
        },
      ];
      commit('SET_QUESTION_LIST', currentList);
      // commit('SET_CURRENT_QUESTION', currentList[0] || {options:[]});
      commit('SET_CURRENT_QUESTION_INDEX', 0);
      commit('SET_TOTAL_COUNT', 30);
    },

  },
}

export default question;
