import { ENV_CONFIG } from './enumerate';

const { VUE_APP_ENV } = process.env;

export const setCookie = (
  cname,
  cvalue,
  exdays = 7,
  domain = '.yunqueyi.com',
  validMsec
) => {
  // yunqueyi.com
  const d = new Date();
  let expires = '';
  if ( VUE_APP_ENV === 'development') {
    domain = window.location.hostname;
  }
  if (validMsec) {
    d.setTime(d.getTime() + validMsec);
  } else {
    d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000);
  }
  expires = `expires=${d.toUTCString()}`;

  // document.cookie = `${cname}=${cvalue};path=/;${expires}`;
  document.cookie = `${cname}=${cvalue};path=/;${expires};domain=${domain}`;
};

export const getCookie = (cname) => {
  const reg = new RegExp('(^| )' + cname + '=([^;]*)(;|$)');
  const arr = document.cookie.match(reg);

  return arr ? unescape(arr[2]) : null;
};

export const delCookie = (name) => {
  var exp = new Date();
  exp.setTime(exp.getTime() - 1);
  var cval = getCookie(name);

  if (cval !== null) {
    // document.cookie = name + "="+cval+";expires="+exp.toGMTString();
    document.cookie = name + '=; path=/; expires=' + new Date(0).toUTCString();
    document.cookie =
      name +
      '=; path=/; domain=.yunqueyi.com; expires=' +
      new Date(0).toUTCString();
    document.cookie =
      name +
      '=; path=/; domain=dev-phome.yunqueyi.com;expires=' +
      new Date(0).toUTCString();
    document.cookie =
      name +
      '=; path=/; domain=test1-phome.yunqueyi.com;expires=' +
      new Date(0).toUTCString();
    document.cookie =
      name +
      '=; path=/; domain=uat-phome.yunqueyi.com;expires=' +
      new Date(0).toUTCString();
    document.cookie =
      name +
      '=; path=/; domain=phome.yunqueyi.com;expires=' +
      new Date(0).toUTCString();
    document.cookie =
      name +
      '=; path=/; domain=.dev-phome.yunqueyi.com;expires=' +
      new Date(0).toUTCString();
    document.cookie =
      name +
      '=; path=/; domain=.test1-phome.yunqueyi.com;expires=' +
      new Date(0).toUTCString();
    document.cookie =
      name +
      '=; path=/; domain=.uat-phome.yunqueyi.com;expires=' +
      new Date(0).toUTCString();
    document.cookie =
      name +
      '=; path=/; domain=.phome.yunqueyi.com;expires=' +
      new Date(0).toUTCString();
  }
};

export const formatDate = (datetime) => {
  var date = new Date(datetime); // 时间戳为10位需*1000，时间戳为13位的话不需乘1000
  var year = date.getFullYear(),
    month = ('0' + (date.getMonth() + 1)).slice(-2),
    sdate = ('0' + date.getDate()).slice(-2),
    hour = ('0' + date.getHours()).slice(-2),
    minute = ('0' + date.getMinutes()).slice(-2),
    second = ('0' + date.getSeconds()).slice(-2);
  // 拼接
  var result =
    year + '-' + month + '-' + sdate + ' ' + hour + ':' + minute + ':' + second;
  // 返回
  return result;
};

export const formatDay = (datetime) => {
  var date = new Date(datetime);
  var year = date.getFullYear(),
    month = ('0' + (date.getMonth() + 1)).slice(-2),
    day = ('0' + date.getDate()).slice(-2);
  // 拼接
  var result = year + '-' + month + '-' + day;
  // 返回
  return result;
};

// 判断是否是微信
export function isWeixin() {
  const ua = navigator.userAgent.toLowerCase();
  return ua.match(/MicroMessenger/i) === 'micromessenger';
}

// 时间戳 格式化为 时分秒（00: 00: 00）
export const formatDuring = (time) => {
  const s = Math.floor(time / 1000);
  if (!s) {
    return '';
  }
  let t = '';
  if (s > -1) {
    const hour = Math.floor(s / 3600);
    const min = Math.floor(s / 60) % 60;
    const sec = s % 60;
    if (hour) {
      if (hour < 10) {
        t = '0' + hour + ':';
      } else {
        t = hour + ':';
      }
    }
    if (min < 10) {
      t += '0';
    }
    t += min + ':';
    if (sec < 10) {
      t += '0';
    }
    t += sec.toFixed(0);
  }
  return t;
};

export function toDecimal2(x) {
  if (isNaN(x)) {
    return '';
  }
  const f = x / 100;
  let s = f.toString();
  let rs = s.indexOf('.');
  if (rs < 0) {
    rs = s.length;
    s += '.';
  }
  while (s.length <= rs + 2) {
    s += '0';
  }
  return s;
}

/**
 * 通过身份证获取出生日期及性别
 * @param idCard 15/18位身份证号码
 * @return JSON对象
 *         sex：2-女、1-男；
 *         birthDay：yyyy-MM-dd
 */

export function getBirthdayAndSex(idCard) {
  const info = {};
  const birth =
    idCard.length === 18 ? idCard.slice(6, 14) : idCard.slice(6, 12);
  // 18位：提取第17位数字；15位：提取最后一位数字
  const order = idCard.length == 18 ? idCard.slice(-2, -1) : idCard.slice(-1);
  info.birthDay =
    idCard.length === 18
      ? [birth.slice(0, 4), birth.slice(4, 6), birth.slice(-2)].join('-')
      : ['19' + birth.slice(0, 2), birth.slice(2, 4), birth.slice(-2)].join(
          '-'
        );
  // 余数为0代表女性，不为0代表男性
  info.sex = order % 2 === 0 ? 2 : 1;
  return info;
}

/*
 *
 * */
export const getSearchByName = (name) => {
  const match = RegExp(`[?&]${name}=([^&]*)`).exec(window.location.href);
  return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
};

export const getItem = (name) => {
  if (!name) return;
  const v = sessionStorage.getItem(name);
  let val = null;
  try {
    val = JSON.parse(v);
  } catch (e) {
    // JSON.parse 失败 后 直接赋v给val;
    val = v;
  }
  return val;
};

export const setItem = (name, value) => {
  if (!name) return;
  if (typeof value !== 'string') {
    value = JSON.stringify(value);
  }
  sessionStorage.setItem(name, value);
};

export const removeItem = (name) => {
  if (!name) return;
  sessionStorage.removeItem(name);
};

export const getConfigByEvtType = (key) => {
  return ENV_CONFIG[VUE_APP_ENV][key];
};

// 获取SC服务器域名地址
export const getBaseUrl = (url) => {
  return `${getConfigByEvtType('baseUrl')}${url}`;
};

export const getShareUrl = (url = '') => {
  return `${getConfigByEvtType('shareUrl')}${url}`;
};

export const getClosePageUrl = () => {
  return `${getConfigByEvtType('colseUrl')}`;
};

export const getKFAccid = () => {
  return `${getConfigByEvtType('kfaccid')}`;
};

/**
 * iPhone X、iPhone XS
 */
export const isIPhoneX = () => {
  return (
    /iphone/gi.test(window.navigator.userAgent) &&
    window.devicePixelRatio &&
    window.devicePixelRatio === 3 &&
    window.screen.width === 375 &&
    window.screen.height === 812
  );
};

/**
 * iPhone XS Max
 */
export const isIPhoneXSMax = () => {
  return (
    /iphone/gi.test(window.navigator.userAgent) &&
    window.devicePixelRatio &&
    window.devicePixelRatio === 3 &&
    window.screen.width === 414 &&
    window.screen.height === 896
  );
};

/**
 * iPhone XR
 */
export const isIPhoneXR = () => {
  return (
    /iphone/gi.test(window.navigator.userAgent) &&
    window.devicePixelRatio &&
    window.devicePixelRatio === 2 &&
    window.screen.width === 414 &&
    window.screen.height === 896
  );
};

// 获取APP版本号（数值型）
export function getAppVersion(appVersion) {
  if (!appVersion) return 200;
  return appVersion.split('.').join('');
}

// 通用（原生）跳转（到H5页面）
export function gotoPageByNative(vm, pageUrl) {
  const paramList = [
    {
      key: 'pageUrl',
      value: pageUrl,
    },
  ];
  vm.$rocNative.dispatchEventByModuleCode({
    modeCode: 'M300',
    jsonString: paramList,
  });
}

// 通用（原生）跳转（到原生页面）
export function gotoNativePage(vm, className) {
  const paramList = [
    {
      key: 'className',
      value: className,
    },
  ];
  vm.$rocNative.dispatchEventByModuleCode({
    modeCode: 'M200',
    jsonString: paramList,
  });
}

// 获取头部高度
export const getHeaderHeight = () => {
  return 38 + 36;
};
// 获取状态栏高度（单位：px）
export const getStatusHeight = () => {
  this.$rocNative.getStatusBarHeight().then((res) => {
    console.log(res, 'getStatusBarHeightgetStatusBarHeight');
    return res;
  });
};
export const setEventByModuleCode = (itemData, token) => {
  const modeCode = itemData.code || '';
  let paramList = itemData.paramList ? itemData.paramList : '';
  if (modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
    paramList = '';
  } else if (
    modeCode === 'M100' ||
    modeCode === 'M300' ||
    modeCode === 'M500' ||
    modeCode === 'M301'
  ) {
    const urlPara = getUrlParmByCode(paramList, token);
    paramList[0] && (paramList[0].value += urlPara);
    // 前端拼接了数据，原生不用再拼接
    paramList = paramList.slice(0, 1);
  }

  if (typeof paramList === 'string' && !paramList) {
    paramList = [];
  }

  return paramList;
};

function getUrlParmByCode(paramList, token) {
  if (paramList.length <= 1) return `?token=${token}`;
  let dataStr = '';
  const list = [];
  const str =
    paramList.length > 0 && paramList[0].value.indexOf('?') > -1 ? '&' : '?';

  for (let i = 1; i < paramList.length; i++) {
    list.push(paramList[i].key + '=' + encodeURI(paramList[i].value));
  }
  dataStr = list.join('&');

  if (dataStr !== '') return `${str}${dataStr}&token=${token}`;
  return `${str}token=${token}`;
}
