import { router } from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';
import Index from '@/views/Home.vue';
import {toggleSkeletonRouter} from 'mn-template/plugins/toggleSkeleton.js';
import handleAllRouter from '../public_uat';
const routerConfig = [
  {
    path: '/',
    name: 'Index',
    component: Index
  },
  {
		path: '/stroke',
    name: 'stroke',
    component: () => import('@/views/stroke/index.vue'),
  },
  {
      path: '/exam',
      name: 'exam',
      component: () => import('@/views/exam/index.vue')
  },
  {
      path: '/exam-result',
      name: 'exam-result',
      component: () => import('@/views/examResult/index.vue')
  },
  {
      path: '/exam-wrong',
      name: 'exam-wrong',
      component: () => import('@/views/exam/exam_wrong.vue')
  },
  {
      path: '*',
      redirect: process.env.VUE_APP_BASE_ROUTE
    }
];

router.beforeEach(async (to, from, next) => {
  toggleSkeletonRouter(to, from);
  next();
});

router.addRoutes(routerConfig);

if (process.env.VUE_APP_ENV == 'uat') {
  const routerInfo = {
    routerConfig: routerConfig,
  };
  handleAllRouter(routerInfo);
}
