import time
from unittest import TestCase
from appium import webdriver
from util import config
from util import tools


class Login(TestCase):

    def setUp(self):
        self.driver = webdriver.Remote(config.host, config.get_caps())

    def tearDown(self):
        pass

    def test_login_code(self):
        tools.get_app_log("test_login_code")
        time.sleep(1)

        try:
            self.driver.find_element_by_id("tv_exist_account").click()
            time.sleep(2)
            self.driver.find_element_by_id("ll_login_bycode").click()
            time.sleep(1)
            self.driver.find_element_by_id("ed_phone").send_keys("15606680071")
            self.driver.find_element_by_id("ed_code").send_keys("089898")
            self.driver.find_element_by_id("btn_user_login").click()
        except Exception as e:
            self.driver.save_screenshot(tools.get_screenshot_dir("test_login_code"))
            print(e)
            tools.save_log(e)

    def test_login_pwd(self):
        time.sleep(1)

        try:
            self.driver.find_element_by_id("tv_exist_account").click()
            time.sleep(2)
            self.driver.find_element_by_id("ll_login_bypwd").click()
            time.sleep(1)
            self.driver.find_element_by_id("ed_phone").send_keys("15606680071")
            self.driver.find_element_by_id("ed_pwd").send_keys("15606680072")
            self.driver.find_element_by_id("btn_user_login").click()
        except Exception as e:
            self.driver.save_screenshot(tools.get_screenshot_dir("test_login_pwd"))
            print(e)
            tools.save_log(e)

    def test_login_wechat(self):
        time.sleep(2)

        try:
            self.driver.find_element_by_id("bt_next").click()
            time.sleep(2)
            self.driver.find_element_by_id("ed_phone").send_keys("15606680071")
            # Tools.get_validate_code(self)
            self.driver.find_element_by_id("ed_code").send_keys("245456")
            self.driver.find_element_by_id("ed_pwd").send_keys("123456a")
            time.sleep(1)
            self.driver.find_element_by_id("btn_user_login").click()
            self.driver.save_screenshot(tools.set_file_path('images/') + 'Login.png')
        except Exception as e:
            print(e)