import unittest
import time
import HTMLTestRunner
from functions.login import Login
from functions.register import Register
from util import tools

if __name__ == '__main__':
    suite = unittest.TestSuite()
    suite.addTest(Login("test_login_code"))
    suite.addTest(Login("test_login_pwd"))
    suite.addTest(Register("test_register"))

    filename = tools.get_report_dir() + time.strftime("%Y_%m_%d_%H_%M_%S", time.gmtime()) + '_result.html'
    fp = open(filename, 'wb')
    runner = HTMLTestRunner.HTMLTestRunner(stream=fp, title='测试报告', description='用例执行情况:')
    runner.run(suite)
    fp.close()
