import logging
from common.caps import appium_caps
from selenium.webdriver.common.by import By
from businessView.loginView import LoginView


class ModifyEdu(LoginView):
    mainMeTop = (By.ID, 'main_me_top')
    modifyEduBtn = (By.ID, 'tv_edu_info_edit')
    schoolInput = (By.ID, 'doc_school')
    majorInput = (By.ID, 'doc_major')
    majorListItem = (By.ID, 'item_layout')
    eduInput = (By.ID, 'doc_education')
    yearInput = (By.ID, 'admin_enrollment_year')

    def modify_education(self, schoolName):
        self.login_pwd('15606680071', '15606680072')
        logging.info('go to myInfo activity')
        self.driver.find_element(*self.mainMeTop).click()
        self.driver.find_element(*self.modifyEduBtn).click()
        self.driver.find_element(*self.schoolInput).send_keys(schoolName)
        self.driver.find_element(*self.majorInput).click()
        self.driver.find_elements(*self.majorListItem)[1].click()
        self.driver.find_element(*self.eduInput).click()
        self.driver.find_elements(*self.majorListItem)[3].click()
        self.driver.find_element(*self.yearInput).click()
        self.driver.find_elements(*self.majorListItem)[4].click()
        self.driver.find_element(*self.modifyEduBtn).click()


    def check_modify_edu(self, schoolName):
        self.getScreenShot('modify_education')
        if schoolName == self.driver.find_element(*self.schoolInput).get_attribute('text'):
            logging.info('modify edu success')
            return True
        else:
            logging.info('modify edu fail')
            return False

if __name__ == '__main__':
    driver = appium_caps()
    m = ModifyEdu(driver)
    m.modify_education('西安邮电大学')
    m.check_modify_edu('西安邮电大学')
