from appium import webdriver
import yaml
import logging
import logging.config
import os
import multiprocessing
from util.tools import get_config_dir

CON_LOG= get_config_dir() + "log.conf"
logging.config.fileConfig(CON_LOG)
logging=logging.getLogger()

# 多设备
device_list = []

# 保留参数，多设备使用
def appium_caps(uuid='', port=''):
    with open(get_config_dir() + 'setting.yaml', 'r', encoding='utf-8') as f:
        deviceInfo = yaml.load(f, Loader=yaml.FullLoader)

    caps = {}
    caps["platformName"] = deviceInfo['platformName']

    caps["platformVersion"] = deviceInfo['platformVersion']
    caps["deviceName"] = deviceInfo['deviceName']
    caps["automationName"] = deviceInfo['automationName']

    base_dir = os.path.dirname(os.path.dirname(__file__))
    app_path = os.path.join(base_dir, 'app', deviceInfo['app'])
    caps["app"] = app_path
    caps["appPackage"] = deviceInfo['appPackage']
    caps["appActivity"] = deviceInfo['appActivity']
    caps["noReset"] = deviceInfo['noReset']

    logging.info('start app...')
    driver = webdriver.Remote("http://" + str(deviceInfo['host'] + ":" + str(deviceInfo['port']) + "/wd/hub"), caps)
    driver.implicitly_wait(5)
    return driver


caps_process = []

# for i in range(len(device_list)):
#     port = 4723 + 2*i
#     caps = multiprocessing.Process(target=appium_caps, args=())
#     caps_process.append(caps)

for i in range(1):
    port = 4723 + 2*i
    caps = multiprocessing.Process(target=appium_caps)
    caps_process.append(caps)

if __name__ == '__main__':
    # appium_caps()
    for cap in caps_process:
        cap.start()
    for cap in caps_process:
        cap.join()