from baseView.baseView import BaseView
from common.caps import appium_caps
from selenium.common.exceptions import NoSuchElementException
import logging
import time
import os
from selenium.webdriver.common.by import By
import csv

class Common(BaseView):
    skipBtn = (By.ID, 'adv_text')
    activeBtn = (By.ID, 'notice_close')
    upGradeBtn = (By.ID, 'btn_ignore')


    def check_skip(self):
        logging.info('check spnash activity')
        try:
            skip = self.driver.find_element(*self.skipBtn)
        except NoSuchElementException:
            pass
        else:
            logging.info('skip spnash button')
            skip.click()

    def get_size(self):
        x = self.driver.get_window_size()['width']
        y = self.driver.get_window_size()['height']
        return x, y

    def swipeLeft(self):
        size = self.get_size()
        x1 = int(size[0] * 0.9)
        y1 = int(size[1] * 0.5)
        x2 = int(size[0] * 0.1)
        self.swipe(x1, y1, x2, y1, 1000)

    def swipeRight(self):
        size = self.get_size()
        x1 = int(size[0] * 0.9)
        y1 = int(size[1] * 0.5)
        x2 = int(size[0] * 0.1)
        self.swipe(x2, y1, x1, y1, 1000)

    def swipeUp(self):
        size = self.get_size()
        x1 = int(size[0] * 0.5)
        y1 = int(size[1] * 0.9)
        y2 = int(size[1] * 0.1)
        self.swipe(x1, y1, x1, y2, 1000)

    def swipeDown(self):
        size = self.get_size()
        x1 = int(size[0] * 0.5)
        y1 = int(size[1] * 0.9)
        y2 = int(size[1] * 0.1)
        self.swipe(x1, y2, x1, y1, 1000)

    def getTime(self):
        self.now = time.strftime("%Y-%m-%d %H_%M_%S")
        return self.now

    def getScreenShot(self, module):
        time = self.getTime()
        image_file=os.path.dirname(os.path.dirname(__file__))+'/screenshots/%s_%s.png' %(module, time)
        logging.info('get %s screenshot' %module)
        self.driver.save_screenshot(image_file)

    def checkActive(self):
        time.sleep(1)
        logging.info('check active ad')
        try:
            active = self.driver.find_element(*self.activeBtn)
        except NoSuchElementException:
            logging.info('no active alive')
        else:
            logging.info('skip active button')
            active.click()

    def checkAppUpGrade(self):
        time.sleep(1)
        logging.info('check app upgrade')
        try:
            upgrade = self.driver.find_element(*self.upGradeBtn)
        except NoSuchElementException:
            logging.info('no app upgrade alive')
        else:
            logging.info('skip app upgrade button')
            upgrade.click()

    def get_csv_data(self, csc_file, line):
        logging.info('get csv account')
        with open(csc_file, 'r', encoding='utf-8-sig') as file:
            reader = csv.reader(file)
            for index, row in enumerate(reader,1):
                if index == line:
                    return row



if __name__ == '__main__':
    # driver=appium_caps()
    # com = Common(driver)
    # com.getScreenShot('start app')
    csv_file = '../data/account.csv'
