import unittest
import time, logging
import HTMLTestRunner
from test_case.test_login import TestLogin
from test_case.test_modify_edu import TestModifyEdu
from appium_sync.appium_device import start_appium_action
from util.tools import get_dir_by_name
from appium_sync.check_port import release_port
from time import sleep


test_dir = get_dir_by_name('test_case')
report_dir =get_dir_by_name('reports')

now = time.strftime("%Y_%m_%d_%H_%M_%S")
report_name = report_dir + '/' + now + '_result.html'

with open(report_name, 'wb') as file:
    start_appium_action('127.0.0.1', 4723)
    sleep(2)
    suite = unittest.TestSuite()
    suite.addTest(TestLogin("test_login_by_psw"))
    suite.addTest(TestModifyEdu("test_modify_edu"))
    runner = HTMLTestRunner.HTMLTestRunner(stream=file, title='云鹊医测试报告', description='用例执行情况:')
    logging.info('start run test case')
    runner.run(suite)
    release_port('4723')


