from appium_sync.start_appium import appium_auto_start
from common.caps import appium_caps
from appium_sync.check_port import *
from time import sleep
import multiprocessing
import logging


def start_appium_action(host, port):
    if (check_port(host, port)):
        logging.info('appium starting')
        appium_auto_start(host, port)
        return True
    else:
        release_port(port)
        sleep(1)
        if (check_port(host, port)):
            logging.info('appium starting')
            appium_auto_start(host, port)
            return True
        else:
            logging.info('appium %s start fail' % port)
            return False

def start_device_action(uuid, port):
    host = '127.0.0.1'
    if start_appium_action(host, port):
        # 等待appium启动
        sleep(3)
        appium_caps(uuid, port)
    else:
        logging.info('start appium device fail')

