import logging
from common.common_fun import Common
from common.caps import appium_caps
from selenium.webdriver.common.by import By
from selenium.common.exceptions import NoSuchElementException


class LoginView(Common):
    mainMeBtn = (By.ID, 'tab_me_item')
    loginBtn = (By.ID, 'btn_user_login')
    userName = (By.ID, 'doc_name')

    login_by_pwd = (By.ID, 'com.picahealth.yunque:id/ll_login_bypwd')
    mobile = (By.ID, 'ed_phone')
    password = (By.ID, 'ed_pwd')

    login_by_wechat = (By.ID, 'iv_wx_login')

    settingBtn = (By.ID, 'ic_me_shezhi')
    logoutBtn = (By.ID, 'btn_logout')
    sureBtn = (By.ID, 'cancel')

    def login_pwd(self, userName, password):
        if not self.check_login_status():
            logging.info('start login')
            self.driver.find_element(*self.login_by_pwd).click()
            self.driver.find_element(*self.mobile).send_keys(userName)
            self.driver.find_element(*self.password).send_keys(password)
            self.driver.find_element(*self.loginBtn).click()

    def login_wechat(self):
       pass


    def check_login_status(self):
        self.checkActive()
        # self.checkAppUpGrade()

        try:
            self.driver.find_element(*self.mainMeBtn).click()
            self.driver.find_element(*self.userName)
        except NoSuchElementException:
            logging.info('current is not logined')
            return False
        else:
            logging.info('current is logined')
            self.getScreenShot('logined')
            return True

    def logout(self):
        if self.check_login_status():
            logging.info('start logout')
            self.driver.find_element(*self.settingBtn).click()
            self.driver.find_element(*self.logoutBtn).click()
            self.driver.find_element(*self.sureBtn).click()

if __name__ == '__main__':
    driver = appium_caps()
    l = LoginView(driver)
    l.login_pwd('15606680071', '15606680072')
    l.check_login_status()



