package com.config

/**
  *
  * 埋点流量相关常量配置
  * @Author zhenxin.ma
  * @Date 2019/8/20 9:43
  * @Version 1.0
  */
object MyConfigSession {
    //Hive的DW层流量表
    final val HIVE_TABLE1: String = "pica_dw.dw_fact_log_session"
    final val HIVE_TABLE2: String = "pica_dw.dw_fact_log_session_path"
    //写入的文件路径
    final val PARQUET_PATH: String = "hdfs://bi-name1:8020/tmp/output/"


    //流量表中的临时视图
    final val VIEW_SESSION_ODS: String = "ods_session"
    final val VIEW_SESSION_NO_MATCH: String = "ods_session_no_user_id"
    final val VIEW_EQUIPMENT_INFO: String = "equipment_info"
    final val VIEW_DEVICE_TOKEN: String = "device_token_match"


    //流量表中使用的三个字典表作为过滤数据条件
    final val ACTION_TYPE_SQL: String = "select action_type,'1' as is_valid from pica_dw.dw_dim_log_action_type where is_valid=1"
    final val CLASS_NAME_SQL: String = "select class_name, '0' as is_valid from pica_dw.dw_dim_log_class_name where is_valid=0"
    final val MENU_CODE_SQL: String = "select view_path,  menu_code from pica_dw.dw_dim_log_menu_class_code where view_path is not Null"
    //流量表中根据action_type获取对应的action_category类型
    final val ACTION_CATEGORY_SQL: String = "select action_type,action_category from pica_dw.dw_dim_log_action_type where is_valid=1"



    //从源表pica_log.picalog_trace_app_part中执行SQL获取源数据,这里获取昨天的
    final val SOURCE_SQL: String =
        """
          		  |select pseudo_session,doctor_id,mobile,device_token,user_token_tourist,class_name,view_path,action,
          		  |component_tag,app_version,device_type,device_brand,device_model,network_type,created from pica_log.picalog_trace_app_part
          		  | where created_day = DATE_SUB(current_date(),1) and pseudo_session is not null and pseudo_session !=''
          		  | and pseudo_id !='' and extra_info !='com.picahealth.patient' and serviceName != 'trace3'
        		""".stripMargin


    //从源表pica_log.picalog_trace_app_part中执行SQL获取源数据,输入指定日期参数时执行的SQL
    final val SOURCE_SQL_ARGS: String =
        """
          		  |select pseudo_session,doctor_id,mobile,device_token,user_token_tourist,class_name,view_path,action,
          		  |component_tag,app_version,device_type,device_brand,device_model,network_type,created from pica_log.picalog_trace_app_part
          		  | where pseudo_session is not null and pseudo_session !=''
          		  | and pseudo_id !='' and extra_info !='com.picahealth.patient' and serviceName != 'trace3'
        		""".stripMargin


    //从dw_fact_log_session表中筛选数据
    final val SOURCE_SQL_PATH: String =
        s"""
          |select session_id,user_id,action_type,user_token,menu_code,action_code,position,label_value,
          |app_version,device_type,created_time,date_time from ${MyConfigSession.HIVE_TABLE1}
          | where created_day=DATE_SUB(current_date(),1) and app_version >= '3.1.7'
          | AND ((action_type ='ACTION_CLICK') OR (action_type ='ACTION_VIEW' and menu_code != '0' and menu_code !='null' and menu_code !=''))
        """.stripMargin



    //匹配user_id的条件
    //0.使用pica_ds.pica_doctor表匹配,匹配不上的user_id值为'0'
    final val INIT_USER_ID_SQL =
      s"""
         |SELECT t.session_id, COALESCE(cast(b.id as string),'0') AS user_id, t.mobile, t.device_token, t.user_token,
         |t.view_class,t.view_path,t.action_type,t.component_tag, t.menu_code,
         |t.action_code, t.position, t.label_value,t.app_version,t.device_type,
         |t.device_brand, t.device_model, t.device_system,t.net_type,t.created_time,
         |t.date_time from ${MyConfigSession.VIEW_SESSION_ODS} as t
         |left join pica_ds.pica_doctor as b on t.user_id = cast(b.id as string)
  """.stripMargin
    //1.使用equipment表匹配,默认是昨天的
    final val EQUIPMENT_INFO_SQL: String =
    """
      |SELECT a.user_id,a.device_token ,ROW_NUMBER() OVER ( PARTITION BY a.device_token ORDER BY a.creat_time DESC ) row_d
      |from pica_ds.picams_equipment_info AS a
      | where a.user_id IS NOT NULL
      | AND (to_date(a.creat_time) = date_sub(current_date(),1) OR to_date(a.modify_time) = date_sub(current_date(),1))
    """.stripMargin

    //注意:1.使用equipment表匹配,如果匹配的是历史指定日期的数据,那么需要使用不同的表和下面这个SQL表,限定stat_date日期
    final val EQUIPMENT_INFO_SQL_ARGS: String =
    """
      		|SELECT a.doctor_id as user_id, a.device_token, ROW_NUMBER() OVER (PARTITION BY a.device_token ORDER BY a.creat_time DESC) row_d
      		| from pica_ods.ods_zipper_picams_equipment_info AS a where a.doctor_id IS NOT NULL AND a.stat_date=
    """.stripMargin


    //先和equiment表进行匹配,使用 device_token 匹配,得到 user_id 匹配,'0'
    final val DEVICE_TOKEN_SQL: String =
        s"""
           |SELECT t.session_id, COALESCE(cast(b.user_id as string),'0') AS user_id, t.mobile, t.device_token, t.user_token,
           |t.view_class,t.view_path,t.action_type,t.component_tag, t.menu_code,
           |t.action_code, t.position, t.label_value,t.app_version,t.device_type,
           |t.device_brand, t.device_model, t.device_system,t.net_type,t.created_time,
           |t.date_time from ${MyConfigSession.VIEW_SESSION_NO_MATCH} as t
           |left join ${MyConfigSession.VIEW_EQUIPMENT_INFO} as b on t.device_token = b.device_token
  """.stripMargin


    //在device_token匹配的基础上,筛选出没有匹配到的user_id,使用 mobile_phone 进行匹配,得到 user_id 匹配,'0'
    final val MOBILE_PHONE_SQL: String =
        s"""
           |SELECT ss.session_id, COALESCE(cast(b.id as string),'0') AS user_id, ss.mobile, ss.device_token, ss.user_token,
           |ss.view_class,ss.view_path,ss.action_type,ss.component_tag, ss.menu_code,
           |ss.action_code, ss.position,ss.label_value,ss.app_version, ss.device_type,
           |ss.device_brand, ss.device_model,ss.device_system,ss.net_type,ss.created_time,
           |ss.date_time from (select * from ${MyConfigSession.VIEW_DEVICE_TOKEN} as a where a.user_id = '0') AS ss
           |left join (select id,mobile_phone from pica_ds.pica_doctor where pica_doctor.delete_flag = 1 ) AS b on ss.mobile = b.mobile_phone
  """.stripMargin



    //sessionGap时间,切割 session 的依据,30 minutes
    final val SESSION_GAP: Long = 30 * 60 * 1000
    //分隔符
    final val DELIMITER: String = "\001"

    //hdfs127 Mysql配置,记录任务的执行情况
    final val JDBC_DRIVER = "com.mysql.jdbc.Driver"
    final val DATA_BASE = "pica_job"
    final val JDBC_URL = s"jdbc:mysql://hdfs127:3306/${DATA_BASE}?useTimezone=true&serverTimezone=GMT%2B8"
    final val JDBC_USERNAME = "pica_spider"
    final val JDBC_PSSWORD = "5$7FXgz#e5JWP08e"
    final val JDBC_TABLE = "schedule_job_record"

}
