package com.session

import com.config.MyConfigSession
import com.pica.utils.DateUtils
import com.utils.{JDBCUtil, UseUtil}
import org.apache.spark.SparkConf
import org.apache.spark.rdd.RDD
import org.apache.spark.sql.{DataFrame, Row, SparkSession}

import java.sql
import java.sql.PreparedStatement
import scala.collection.mutable.ListBuffer


/**
 *
 * @Author 毛伟成
 * @Date 2021/07/12 10:58
 * @Version 1.0
 */
object Pathconvertconfig {
  def apply(): Pathconvertconfig = new Pathconvertconfig()

  def noposition_calculation(sparkSession: SparkSession, resList: ListBuffer[SourceConfig],i:Int,j:Int) = {


    val frame = sparkSession.sql(
      s"""
         |select
         |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,
         |B.refer_menu_code,B.refer_action_code,B.starttime,B.endtime,A.user_id,
         |A.created_time,A.refer_time_diff
         |from sourceConfig B
         | join sourcePathConvert A on A.menu_code=B.menucode AND
         | (CASE when A.action_code="" THEN '0' ELSE A.action_code END )=B.actioncode
         |and A.created_day>=B.startTime AND A.created_day<=endtime
         |AND B.nodeid='${j}' AND B.projectid='${i}'
         |""".stripMargin)
    frame.createOrReplaceTempView("path_config"+j)

    val frame1: DataFrame = sparkSession.sql(
      s"""
         |select
         |projectid,nodeid,nodename,menucode,actioncode,count(distinct user_id) as UV,
         |refer_menu_code,refer_action_code,starttime,endtime
         |from path_config${j}
         |where nodeid='${j}' and projectid='${i}'
         |group by projectid,nodeid,nodename,menucode,actioncode,refer_menu_code,refer_action_code,starttime,endtime
         |""".stripMargin).toDF()
    frame1.show()

    val lists: List[SourceConfig] = frame1.rdd.map(row => {
      SourceConfig(row.getAs[String]("projectid"),
        row.getAs[String]("nodeid"),
        row.getAs[String]("nodename"),
        row.getAs[String]("menucode"),
        row.getAs[String]("actioncode"),
        row.getAs[Long]("UV").toString,
        row.getAs[String]("refer_menu_code"),
        row.getAs[String]("refer_action_code"),
        row.getAs[String]("starttime"),
        row.getAs[String]("endtime")
      )

    }).collect().toList
    lists.foreach(row=>{
      resList.append(row)
    })


  }

  def hasPosition_calculation(sparkSession: SparkSession, resList: ListBuffer[SourceConfig], i: Int, j: Int) = {
    val frame = sparkSession.sql(
      s"""
         |select
         |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,
         |B.refer_menu_code,B.refer_action_code,B.starttime,B.endtime,A.user_id,
         |A.created_time,A.refer_time_diff
         |from sourceConfig B
         | join sourcePathConvert A on A.menu_code=B.menucode AND
         | (CASE when A.action_code="" THEN '0' ELSE A.action_code END )=B.actioncode
         | and A.position=B.position
         |and A.created_day>=B.startTime AND A.created_day<=endtime
         |AND B.nodeid='${j}' AND B.projectid='${i}'
         |""".stripMargin)
    frame.createOrReplaceTempView("path_config"+j)

    val frame1: DataFrame = sparkSession.sql(
      s"""
         |select
         |projectid,nodeid,nodename,menucode,actioncode,count(distinct user_id) as UV,
         |refer_menu_code,refer_action_code,starttime,endtime
         |from path_config${j}
         |where nodeid='${j}' and projectid='${i}'
         |group by projectid,nodeid,nodename,menucode,actioncode,refer_menu_code,refer_action_code,starttime,endtime
         |""".stripMargin).toDF()

    val lists: List[SourceConfig] = frame1.rdd.map(row => {
      SourceConfig(row.getAs[String]("projectid"),
        row.getAs[String]("nodeid"),
        row.getAs[String]("nodename"),
        row.getAs[String]("menucode"),
        row.getAs[String]("actioncode"),
        row.getAs[Long]("UV").toString,
        row.getAs[String]("refer_menu_code"),
        row.getAs[String]("refer_action_code"),
        row.getAs[String]("starttime"),
        row.getAs[String]("endtime")
      )

    }).collect().toList
    lists.foreach(row=>{
      resList.append(row)
    })


  }

  def path_convert_calculation(sparkSession: SparkSession, resList: ListBuffer[SourceConfig], i: Int, j: Int) = {
    val df2= sparkSession.sql(
      s"""
         |select
         |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,
         |B.refer_menu_code,B.refer_action_code,B.starttime,B.endtime,C.user_id,
         |A.created_time,A.refer_created
         |from sourceConfig B
         |join sourcePathConvert A
         |on A.menu_code=B.menucode AND
         | (CASE when A.action_code="" THEN '0' ELSE A.action_code END )=B.actioncode
         |join path_config${j-1} C
         |on A.refer_created=C.created_time and A.user_id=C.user_id
         |where B.nodeid=${j} AND B.projectid=${i}
         |""".stripMargin)
    df2.createOrReplaceTempView("path_config"+j)


    val outflag: Array[String] = sparkSession.sql(
      s"""
         |select outflag
         |from sourceConfig
         |where projectid=${i} and nodeid=${j}
         |""".stripMargin).rdd.map(row=>row.getAs[String]("outflag")).collect()

    println("outflag:--------------------------------------------------------------------"+outflag(0)+"--------------------------------------------------------------------")
    println("projectid:--------------------------------------------------------------------"+i+"--------------------------------------------------------------------")
    println("nodeid:--------------------------------------------------------------------"+j+"--------------------------------------------------------------------")

    if(outflag(0)=="1"){
      println("进来：outflag:--------------------------------------------------------------------"+outflag(0)+"--------------------------------------------------------------------")

      sparkSession.sql(
        s"""
           |select
           |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,user_id,
           |B.starttime,B.endtime
           |from path_config${j} B
           |""".stripMargin).show()
      println("展示：outflag:--------------------------------------------------------------------"+outflag(0)+"--------------------------------------------------------------------")


      sparkSession.sql(
        s"""
           |insert into  pica_dw.path_convert_config_user
           |select
           |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,user_id,
           |B.starttime,B.endtime
           |from path_config${j} B
           |""".stripMargin)
    }



    val frame = sparkSession.sql(
      s"""
         |select
         |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,count(distinct B.user_id) as UV,
         |B.refer_menu_code,B.refer_action_code,B.starttime,B.endtime
         |from path_config${j} B
         |where nodeid=${j} and projectid=${i}
         |group by B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,B.refer_menu_code,B.refer_action_code,B.starttime,B.endtime
         |""".stripMargin)

    val value: List[SourceConfig] = frame.rdd.map(row => {

      SourceConfig(row.getAs[String]("projectid"),
        row.getAs[String]("nodeid"),
        row.getAs[String]("nodename"),
        row.getAs[String]("menucode"),
        row.getAs[String]("actioncode"),
        row.getAs[Long]("UV").toString,
        row.getAs[String]("refer_menu_code"),
        row.getAs[String]("refer_action_code"),
        row.getAs[String]("starttime"),
        row.getAs[String]("endtime")
      )

    }).collect().toList
    value.foreach(row=>{
      resList.append(row)
    })


  }

  def path_convert_calculation2(sparkSession: SparkSession, resList: ListBuffer[SourceConfig], i: Int, j: Int, flag: Int) = {
    val df2= sparkSession.sql(
      s"""
         |select
         |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,
         |B.refer_menu_code,B.refer_action_code,B.starttime,B.endtime,C.user_id,
         |A.created_time,A.refer_created
         |from sourceConfig B
         |join sourcePathConvert A
         |on A.menu_code=B.menucode AND
         | (CASE when A.action_code="" THEN '0' ELSE A.action_code END )=B.actioncode
         |join path_config${j-flag} C
         |on A.refer_created=C.created_time and A.user_id=C.user_id
         |where B.nodeid=${j} AND B.projectid=${i}
         |""".stripMargin)
    df2.createOrReplaceTempView("path_config"+j)

    val outflag: Array[String] = sparkSession.sql(
      s"""
         |select outflag
         |from sourceConfig
         |where projectid=${i} and nodeid=${j}
         |""".stripMargin).rdd.map(row=>row.getAs[String]("outflag")).collect()

    println("outflag:--------------------------------------------------------------------"+outflag(0)+"--------------------------------------------------------------------")
    println("projectid:--------------------------------------------------------------------"+i+"--------------------------------------------------------------------")
    println("nodeid:--------------------------------------------------------------------"+j+"--------------------------------------------------------------------")



    if(outflag(0)=="1"){

      println("进来：outflag:--------------------------------------------------------------------"+outflag(0)+"--------------------------------------------------------------------")

      sparkSession.sql(
        s"""
           |select
           |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,user_id,
           |B.starttime,B.endtime
           |from path_config${j} B
           |""".stripMargin).show()
      println("展示：outflag:--------------------------------------------------------------------"+outflag(0)+"--------------------------------------------------------------------")


      sparkSession.sql(
        s"""
           |insert into  pica_dw.path_convert_config_user
           |select
           |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,user_id,
           |B.starttime,B.endtime
           |from path_config${j} B
           |""".stripMargin)
    }


    val frame = sparkSession.sql(
      s"""
         |select
         |B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,count(distinct B.user_id) as UV,
         |B.refer_menu_code,B.refer_action_code,B.starttime,B.endtime
         |from path_config${j} B
         |where nodeid=${j} and projectid=${i}
         |group by B.projectid,B.nodeid,B.nodename,B.menucode,B.actioncode,B.refer_menu_code,B.refer_action_code,B.starttime,B.endtime
         |""".stripMargin)

    val value: List[SourceConfig] = frame.rdd.map(row => {

      SourceConfig(row.getAs[String]("projectid"),
        row.getAs[String]("nodeid"),
        row.getAs[String]("nodename"),
        row.getAs[String]("menucode"),
        row.getAs[String]("actioncode"),
        row.getAs[Long]("UV").toString,
        row.getAs[String]("refer_menu_code"),
        row.getAs[String]("refer_action_code"),
        row.getAs[String]("starttime"),
        row.getAs[String]("endtime")
      )

    }).collect().toList
    value.foreach(row=>{
      resList.append(row)
    })


  }

  def main(args: Array[String]): Unit = {
    //1.执行任务之前先往record表记录
    val insertSQL: String =
      s"""
               			   |insert into ${MyConfigSession.DATA_BASE}.${MyConfigSession.JDBC_TABLE} (job_id,job_name,job_type,job_scn,status,start_time)
               			   |values(0,'pica_dw.Pathconvertconfig','3',?,'0',?)
		""".stripMargin
    //设置同步数据的批次号,格式是2019-09-12
    var scnData: String = DateUtils.getYesterdayDate
    var elseFiler = " 1=1"
    if (args.length >= 1) {
      scnData = args(0)
      if(args.length > 1 && args(1)!=""){
        elseFiler = args(1)
      }
    }
    println(s"scnData=${scnData}")
    //设置任务开始时间,格式是2019-09-12 14:03:30
    val startTime: String = DateUtils.getTodayTime
    //存储SQL中的参数
    val insertArr: Array[String] = Array[String](scnData, startTime)
    //获取MYSQL连接
    val connSql: sql.Connection = JDBCUtil.getConnection()
    //向 record 表插入数据
    val flag: Int = JDBCUtil.insertRecord(connSql, insertSQL, insertArr)
    val pathconvertconfig: Pathconvertconfig = Pathconvertconfig()
    try {
      val sparkSession: SparkSession = pathconvertconfig.getSparkSession("pathconvertconfig")
      val sourceConfig: DataFrame = sparkSession.sql(MyConfigSession.SOURCE_SQL_CONFIG )
      val sourcePathConvert: DataFrame = sparkSession.sql(MyConfigSession.SOURCE_SQL_PATH_CONVERT)
      sourceConfig.createOrReplaceTempView("sourceConfig")
      sourcePathConvert.createOrReplaceTempView("sourcePathConvert")


      // 按照project，node和去循环 按照对应表去和sessterm关联
      //查询出有多少个项目
      val projectMax: Array[Int] = sparkSession.sql(
        """
          |select max(cast(projectid as int)) as maxp
          |from sourceConfig
          |""".stripMargin).rdd.map(row=>row.getAs[Int]("maxp")).collect()

      val resList: ListBuffer[SourceConfig] = new ListBuffer[SourceConfig]()

      for(i<- 1 to projectMax(0)){
        println("project")
        //查出每个project的最大的node
        val maxnode = sparkSession.sql(
          s"""
             |select max(cast(nodeid as int)) as maxnode
             |from sourceConfig
             |where projectid='${i}'
             |""".stripMargin).rdd.map(row=>row.getAs[Int]("maxnode")).collect()

        var thisMenuCode = ""

        //距离上一个不同的页面的标记
        var flag=1
        for(j <- 1 to maxnode(0)){
          if(j==1){

            //取出当前的mencode值
            val menucode = sparkSession.sql(
              s"""
                 |select menucode
                 |from sourceConfig
                 |where projectid=${i} and nodeid=${j}
                 |""".stripMargin).rdd.map(row=>row.getAs[String]("menucode")).collect()


            val position = sparkSession.sql(
              s"""
                 |select position
                 |from sourceConfig
                 |where projectid=${i} and nodeid=${j}
                 |""".stripMargin).rdd.map(row=>row.getAs[String]("position")).collect()(0)
            println("展示前：position:--------------------------------------------------------------------"+position+"--------------------------------------------------------------------")


            if(position =="0"){
              println("展示0：position:--------------------------------------------------------------------"+position+"--------------------------------------------------------------------")
              println("展示0：i:--------------------------------------------------------------------"+i+"--------------------------------------------------------------------")
              println("展示0：j:--------------------------------------------------------------------"+j+"--------------------------------------------------------------------")

              noposition_calculation(sparkSession,resList,i,j)
              println("------------------------------------------------------------长度--------------------------------------------------------------"+resList.size)


            }else{
              println("展示不为0：position:--------------------------------------------------------------------"+position+"--------------------------------------------------------------------")
              println("展示0：i:--------------------------------------------------------------------"+i+"--------------------------------------------------------------------")
              println("展示0：j:--------------------------------------------------------------------"+j+"--------------------------------------------------------------------")
              hasPosition_calculation(sparkSession,resList,i,j)
              println("------------------------------------------------------------长度--------------------------------------------------------------"+resList.size)

            }

            thisMenuCode = menucode(0)

            //非 node1的计算
          }else{

            //取出当前的mencode的值与上一个不同的页面值

            val menucode = sparkSession.sql(
              s"""
                 |select menucode
                 |from sourceConfig
                 |where projectid=${i} and nodeid=${j}
                 |""".stripMargin).rdd.map(row=>row.getAs[String]("menucode")).collect()

            println("当前的mencode："+menucode(0))
            println("上一个的mencode："+thisMenuCode)

            if(thisMenuCode !=menucode(0)){
              //重置 距离上一个不同的页面的
              flag=1

              println("展示0：i:--------------------------------------------------------------------"+i+"--------------------------------------------------------------------")
              println("展示0：j:--------------------------------------------------------------------"+j+"--------------------------------------------------------------------")

              path_convert_calculation(sparkSession,resList,i,j)
              println("------------------------------------------------------------长度--------------------------------------------------------------"+resList.size)


              //以下为相同的node处理逻辑
            }else{

              //取出当前的position值
              val position = sparkSession.sql(
                s"""
                   |select position
                   |from sourceConfig
                   |where projectid=${i} and nodeid=${j}
                   |""".stripMargin).rdd.map(row=>row.getAs[String]("position")).collect()(0)

              if(j==2){
                if(position=="0") {

                  println("展示0：i:--------------------------------------------------------------------"+i+"--------------------------------------------------------------------")
                  println("展示0：j:--------------------------------------------------------------------"+j+"--------------------------------------------------------------------")

                  noposition_calculation(sparkSession, resList, i, j)
                  println("------------------------------------------------------------长度--------------------------------------------------------------"+resList.size)
                }else{

                  println("展示0：i:--------------------------------------------------------------------"+i+"--------------------------------------------------------------------")
                  println("展示0：j:--------------------------------------------------------------------"+j+"--------------------------------------------------------------------")

                  hasPosition_calculation(sparkSession,resList,i,j)
                  println("------------------------------------------------------------长度--------------------------------------------------------------"+resList.size)

                }
              }else{
                flag=flag+1

                println("展示0：i:--------------------------------------------------------------------"+i+"--------------------------------------------------------------------")
                println("展示0：j:--------------------------------------------------------------------"+j+"--------------------------------------------------------------------")

                path_convert_calculation2(sparkSession,resList,i,j,flag)
              }
            }
            thisMenuCode =menucode(0)

          }
        }
      }
      import sparkSession.implicits._
      val df = resList.toDF()
      df.printSchema()
      df.show()
      println("长度"+resList.size)
      pathconvertconfig.loadData(df,sparkSession)

      println("----------------------------------update task record table---------------------------------------")
      //任务执行成功,更新 Mysql record 配置表
      val updateSQL: String =
        s"""
           |update ${MyConfigSession.JDBC_TABLE} set status=?,end_time=?,data_count=? where job_name='pica_dw.Pathconvertconfig' and start_time='${startTime}'
				""".stripMargin
      val upreSta: PreparedStatement = connSql.prepareStatement(updateSQL)
      upreSta.setString(1, "1")
      upreSta.setString(2, DateUtils.getTodayTime)
      upreSta.setInt(3, resList.size)
      //更新表数据
      upreSta.executeUpdate()
      //关闭连接
      JDBCUtil.close(connSql, upreSta)

      sparkSession.stop()
    }catch {
      case e:Exception => {
        println("-----------------------------------任务异常---------------------------------------------------")
        e.printStackTrace()
        val exceptionSQL: String =
          s"""
             |update ${MyConfigSession.JDBC_TABLE} set status=?,exception=?,end_time=? where job_id=0 and start_time='${startTime}'
					""".stripMargin
        val errorArr = Array[String]("2", e.getMessage, DateUtils.getTodayTime)
        //                JDBCUtil.insertRecord(connSql, exceptionSQL, errorArr)
        connSql.close()
      }

    }
  }



}

class Pathconvertconfig {
  def getSparkSession(appName: String): SparkSession = {
    val conf: SparkConf = new SparkConf().setAppName(appName)

//              .setMaster("local[*]")
//              .set("dfs.client.use.datanode.hostname", "true")
    UseUtil.setConfigure(conf)
    val sparkSession: SparkSession = SparkSession.builder().config(conf).enableHiveSupport().getOrCreate()
    sparkSession
  }


  /**
   * @Description         导入数据到表中
   * @param dataFrame     源数据
   * @param sparkSession  SparkSession 环境
   * @param partitionDay  分区日期
   * @return void
   **/
  def loadData(dataFrame: DataFrame, sparkSession: SparkSession):Unit = {
    dataFrame.createOrReplaceTempView("result_view")
    val tableName = "pica_dw.pathconvertconfig_result"
    val loadDataSql =
      s"""
         |insert overwrite table ${tableName}
         |select
         |projectid,nodeid,nodename,menucode,actioncode,UV,
         |refer_menu_code,refer_action_code,starttime,endtime,current_date
         |from result_view
                """.stripMargin
    sparkSession.sql(loadDataSql)
  }





}

case class SourceConfig(
                         projectid: String,
                         nodeid: String,
                         nodename: String,
                         menucode: String,
                         actioncode: String,
                         uv: String,
                         refer_menu_code: String,
                         refer_action_code: String,
                         starttime: String,
                         endtime: String
                       )


case class User(name: String, age: Int)
