package com.tmp

import org.apache.spark.{SparkConf, SparkContext}
import org.apache.spark.rdd.RDD
import org.apache.spark.sql.{DataFrame, SparkSession}
import com.tmp.Student

/**
  *
  * 通过转换成JavaBean创建DataFrame
  * @Author zhenxin.ma
  * @Date 2020/3/20 10:46
  * @Version 1.0
  */


object SparkRow_3 {
    def main(args: Array[String]): Unit = {
        val conf: SparkConf = new SparkConf().setAppName("").setMaster("local[*]")
        val sparkSession: SparkSession = SparkSession.builder().config(conf).enableHiveSupport().getOrCreate()
        val sc: SparkContext = sparkSession.sparkContext

        val source: RDD[String] = sc.textFile("file:\\D:\\ideaworkspace\\label\\data\\ss.text")
        val stuRDD: RDD[Student] = source.map(f => {
            val strs: Array[String] = f.split(",")
            new Student(strs(0).toInt, strs(1), strs(2).toInt, strs(3).toInt)
        })

        val df: DataFrame = sparkSession.createDataFrame(stuRDD,classOf[Student])
        df.printSchema()
        df.show(5)
        sparkSession.close()
    }

}
