package com.session

import com.config.MyConfigSession
import com.utils.UseUtil
import org.apache.spark.SparkConf
import org.apache.spark.broadcast.Broadcast
import org.apache.spark.rdd.RDD
import org.apache.spark.sql.expressions.{Window, WindowSpec}
import org.apache.spark.sql.functions.{lag, row_number}
import org.apache.spark.sql.{DataFrame, Dataset, Row, SaveMode, SparkSession}

import scala.collection.mutable.ListBuffer

/**
  * 暂停使用
  * @Author zhenxin.ma
  * @Date 2020/3/24 16:47
  * @Version 1.0
  */

class SessionProcessHistoryPathArgs {

}


object SessionProcessHistoryPathArgs {
    def main(args: Array[String]): Unit = {
        val conf: SparkConf = new SparkConf().setAppName("UserActionAnalyzeArgs")
        UseUtil.setConfigure(conf)
        val sparkSession: SparkSession = SparkSession.builder().config(conf).enableHiveSupport().getOrCreate()
        val sourceSql =
            s"""
               |select session_id,cast(user_id as int) user_id,action_type,user_token,view_path,component_tag,menu_code,action_code,
               |position,label_value,app_version,device_type,created_time,date_time from pica_dw.dw_fact_log_session
               | where created_day='${args(0)}' and app_version >= '3.1.7' and action_type in ('ACTION_CLICK','ACTION_VIEW')
            """.stripMargin

        val sourceDF: DataFrame = sparkSession.sql(sourceSql)
        sourceDF.printSchema()


        //后续的join
        val doctorDF: DataFrame = sparkSession.sql(s"select id from pica_ds.pica_doctor where to_date(creat_time) <='${args(0)}'")
        //获取menu_code广播变量
        val menuCodeBroad: Broadcast[Map[String, String]] =
            UseUtil.getBroadcast(sparkSession, MyConfigSession.MENU_CODE_SQL, "view_path", "menu_code")

        //匹配menu_code
        import sparkSession.implicits._
        val value = sourceDF.rdd.map(row => {
            //关联到menu_code的映射表广播变量
            val path_menu: Map[String, String] = menuCodeBroad.value
            var action_type: String = row.getAs[String]("action_type")

            var menu_code: String = row.getAs[String]("menu_code")

            //补全menu_code
            if (menu_code == null || menu_code.equals("") || menu_code.equals("null") || "ACTION_VIEW".equals(action_type)) {
                import scala.util.control.Breaks._
                breakable {
                    //利用menu_code映射表匹配
                    for (tuple <- path_menu) {
                        //源数据view_path的字符串包含映射表view_path的字符串
                        if (row.getAs[String]("view_path").contains(tuple._1)) {
                            //满足条件后,修改源数据的menu_code
                            menu_code = tuple._2
                            println("--------------------menu_code match successfully-----------------------")
                            //结束遍历
                            break()
                        }
                    }
                    //如果menu_code仍然为空串,那么置为 component_tag(它不为空前提)
                    if ("".equals(menu_code) && (row.getAs[String]("component_tag") !=null)) {
                        menu_code = row.getAs[String]("component_tag")
                    }
                }
            }

            var session_id: String = row.getAs[String]("session_id")
            if (session_id == null) {
                session_id = ""
            }
            var user_id: Int = row.getAs[Int]("user_id")
            if (user_id == null) {
                user_id = 0
            }

            if (action_type == null) {
                action_type = ""
            }
            var user_token: String = row.getAs[String]("user_token")
            if (user_token == null) {
                user_token = ""
            }
            val action_code: String = row.getAs[String]("action_code")
            val position: String = row.getAs[String]("position")
            val label_value: String = row.getAs[String]("label_value")
            var app_version: String = row.getAs[String]("app_version")
            if (app_version == null) {
                app_version = ""
            }
            var device_type: String = row.getAs[String]("device_type")
            if (device_type == null) {
                device_type = ""
            }
            var created_time: String = row.getAs[String]("created_time")
            if (created_time == null) {
                created_time = ""
            }
            var date_time: String = row.getAs[String]("date_time")
            if (date_time == null) {
                date_time = ""
            }
            (session_id,user_id,action_type,user_token,menu_code,action_code,position,label_value,app_version,device_type,created_time,date_time)
        })
        value.toDF("session_id","user_id","action_type","user_token","menu_code","action_code",
            "position","label_value","app_version","device_type","created_time","date_time").registerTempTable("filterview")
        val filterDF =
            sparkSession.sql(
                "select * from filterview where action_type='ACTION_CLICK' OR (action_type='ACTION_VIEW' and menu_code !='null' and menu_code !='' and menu_code !='0')")

        //Join doctor表
        filterDF.join(doctorDF, filterDF("user_id") === doctorDF("id"), "left")
                .createOrReplaceTempView("tmp_table")
        val reSql: String = "select session_id,case when id is null then 0 else user_id END as user_id,action_type," +
                "user_token,menu_code,action_code,position,label_value,app_version,device_type,created_time,date_time from tmp_table"
        val joinDF: DataFrame = sparkSession.sql(reSql)
        println("----------------------- join后数据 ---------------------------")
        joinDF.printSchema()





        println("-------------------------------------refer record----------------------------------------")
        try {
            println("-----------------------------------1111111111111-----------------------------------------")
            //先按照 session_id分区,再按照 created_time排序,进行窗口计算
            val sessionIDWinSpec: WindowSpec = Window.partitionBy("session_id").orderBy("created_time")
            //增叫refer_字段
            val menuDF: DataFrame =
                joinDF.withColumn("refer_menu_code", lag(joinDF("menu_code"), 1).over(sessionIDWinSpec))

            val acodeDF: DataFrame =
                menuDF.withColumn("refer_action_code", lag(menuDF("action_code"), 1).over(sessionIDWinSpec))
            val positionDF: DataFrame =
                acodeDF.withColumn("refer_position", lag(acodeDF("position"), 1).over(sessionIDWinSpec))

            val atypeDF: DataFrame =
                positionDF.withColumn("refer_action_type", lag(positionDF("action_type"), 1).over(sessionIDWinSpec))

            val recreatDF: DataFrame =
                atypeDF.withColumn("refer_created", lag(atypeDF("created_time"), 1).over(sessionIDWinSpec))

            val referDF: DataFrame =
                recreatDF.withColumn("step_id", row_number().over(sessionIDWinSpec))

            //临时视图,为的是去掉第一行中的空值NULL
            referDF.createOrReplaceTempView("rankview")

        } catch {
            case e: Exception => {
                println("--------------------------------任务异常1----------------------------------------------------------")
                println(e.getStackTrace)
                sparkSession.close()
            }
        }


        try {
            println("---------------------------------------22222222222222222-----------------------")
            val coalNullSql =
                """
                  |select session_id,user_id,action_type,user_token,menu_code,action_code,position,label_value,
                  |COALESCE(refer_menu_code,"") as refer_menu_code,
                  |COALESCE(refer_action_code,"") as refer_action_code,
                  |COALESCE(refer_position,"") as refer_position,
                  |COALESCE(refer_action_type,"") as refer_action_type,
                  |COALESCE(refer_created,created_time) as refer_created,
                  |step_id,app_version,device_type,created_time,date_time from rankview
                """.stripMargin
            val coalNullDF: DataFrame = sparkSession.sql(coalNullSql)
            //        在此基础上增加字段 refer_time_diff,值为 created_time, refer_created 之差
            val referTimeDF: DataFrame =
                coalNullDF.withColumn("refer_time_diff", coalNullDF("created_time") - coalNullDF("refer_created"))
            referTimeDF.createOrReplaceTempView("referview")
        } catch {
            case e: Exception => {
                println("--------------------------------------------任务异常2----------------------------")
                println(e.getStackTrace)
                sparkSession.close()
            }
        }


        try{
            println("-----------------------------------33333333333333333333-----------------------------------------")
            val loadSql =
                """
                  |select session_id,user_id,action_type,user_token,menu_code,action_code,position,label_value,
                  |refer_menu_code,refer_action_code,refer_position,refer_action_type,cast(refer_time_diff as int) as refer_time_diff,step_id,
                  |app_version,device_type,created_time,date_time from referview
                """.stripMargin
            val resultDF: DataFrame = sparkSession.sql(loadSql)
            resultDF.createOrReplaceTempView("result_view")
            sparkSession.sql("use pica_dw")
            sparkSession.sql(s"insert overwrite table dw_fact_log_session_path partition(created_day='${args(0)}') select * from result_view")
            sparkSession.close()
        }catch {
            case e:Exception =>{
                println("-------------------------任务异常3---------------------------------------------------")
                println(e.getMessage)
                println(e.getStackTrace)
                sparkSession.close()
            }
        }

    }



}
