package com.tmp

import org.apache.spark.rdd.RDD
import org.apache.spark.sql.{DataFrame, SparkSession}
import org.apache.spark.{SparkConf, SparkContext}

import scala.collection.mutable.ListBuffer

/**
  * @Author zhenxin.ma
  * @Date 2020/3/19 13:02
  * @Version 1.0
  */
object ReduceByKeyTest {
    def main(args: Array[String]): Unit = {
        val conf: SparkConf = new SparkConf().setAppName("").setMaster("local[*]")
        val sc: SparkContext = new SparkContext(conf)
        val rdd: RDD[Int] = sc.parallelize(List(1,1,4,5,6,3,8,9,1,3,4,4,9))
        val mapRDD: RDD[(Int, Int)] = rdd.map((_,2))

        val fu: (Int, Int) => Int = (a:Int,b:Int) => {
            a * b
        }

        val result: RDD[(Int, Int)] = mapRDD.reduceByKey(fu)
        val arr: Array[(Int, Int)] = result.collect()
        arr.foreach(f => {
            println(f._1 + " " + f._2)
        })


    }

}
