package com.utils

import org.apache.hadoop.conf.Configuration
import org.apache.hadoop.hbase.{HBaseConfiguration, TableName}
import org.apache.hadoop.hbase.client.{Connection, ConnectionFactory, HTable, Put}
import org.apache.hadoop.hbase.util.Bytes

import scala.collection.mutable.Map

/**
  * HBase连接工具
  *
  * @Author 	zhenxin.ma
  * @Date 		2019/9/18 15:14
  * @Version 	1.0
  */
object HBaseUtil {

	def getConnection(): Connection = {
		var connection: Connection = null
		try {
			//一个分区创建一个链接，按照分区批量导入
			val hbaseConf: Configuration = HBaseConfiguration.create()
			//获取HBase连接
			connection = ConnectionFactory.createConnection(hbaseConf)
		} catch {
			case e:Exception => {
				println("--------------HBase connect exception-----------------------")
				println(e.getMessage)
			}
		}
		connection
	}


	def getHTable(connection: Connection ,tableName: String): HTable = {
		val table: HTable = connection.getTable(TableName.valueOf(tableName)).asInstanceOf[HTable]
		table
	}


	/**
	 * @Description
	 * @param put		基于rowkey的PUT对象
	 * @param family	列簇
	 * @param columns	列名和列对应的值构建的 Map
	 * @return void
	 **/
	def setPutColumn(put:Put, family:String,columns:Map[String,String]): Unit = {
		columns.foreach(map => {
			val columnName: String = map._1
			val value: String = map._2
			put.addColumn(Bytes.toBytes(family),Bytes.toBytes(columnName),Bytes.toBytes(value))
		})

	}


	def close(connection: Connection, table:HTable): Unit = {
		try{
			if (table != null) {
				table.close()
			}
			if (connection != null) {
				connection.close()
			}
			println("------关闭 HBase 连接和释放资源------")
		}catch {
			case e: Exception => e.printStackTrace()
		}
	}

}
