package com.tmp;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

import java.io.*;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

/**
 * Created by yunfeng@picahealth.com on 2019/7/30.
 */
public class PropertiesUtil {

    public static Map<String, String> propertiesMap = new HashMap<String, String>();

    static {
        String userDir = System.getProperty("user.dir");
        System.out.println("userDir:" + userDir);
        String userHome = System.getProperty("user.home");
        System.out.println("userHome:" + userHome);
        String hdfsPropertiesPath = "D:\\workspaces\\zhuque\\config\\config_tmp.properties";
        if(userHome.startsWith("/")){
            hdfsPropertiesPath = "/user/big-data/script/config/config_tmp.properties";
        }
        System.out.println("hdfsPropertiesPath:" + hdfsPropertiesPath);
        BufferedReader br =null;
        try {
//            in = new BufferedInputStream(new FileInputStream(cleaningPropertiesPath));
//            ResourceBundle resourceBundle = new PropertyResourceBundle(in);
//            for (String key : resourceBundle.keySet()) {
//                String value = resourceBundle.getString(key);
//                propertiesMap.put(key, value);
//            }
            Configuration conf = new Configuration();
            conf.set("fs.hdfs.impl",org.apache.hadoop.hdfs.DistributedFileSystem.class.getName());
            Path path = new Path(hdfsPropertiesPath);
            FileSystem fs = FileSystem.get(conf);
            FSDataInputStream fsin= fs.open(path );
            String line ;
            br = new BufferedReader(new InputStreamReader(fsin));
            while ((line = br.readLine()) != null) {
//                System.out.println("config.line:"+line);
                if(line.contains("=") && !line.trim().startsWith("#")){
                     String rline =line.replaceFirst("="," ");
                    propertiesMap.put(rline.split(" ")[0].trim(),rline.split(" ")[1].trim());
                }
            }
            if("online".equals(propertiesMap.get("spark.model"))){
                System.out.println("propertiesMap:" + propertiesMap);
            }
        } catch (Exception e) {
            e.printStackTrace();
//            throw new RuntimeException(e.getMessage());
        } finally {
            try {
                if(br!=null){
                    br.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}
