package com.pica.utils;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

/**
 * 读取HDFS配置文件
 * @Author zhenxin.ma
 * @Date 2020/1/2 14:50
 * @Version 1.0
 */
public class PropertiesUtil {
	public static Map<String, String> propertiesMap = new HashMap();

	static {
		//HDFS配置文件路径
		String hdfsPropertiesPath = "/user/big-data/script/config2/config.properties";
		System.out.println("hdfsPropertiesPath is :" +hdfsPropertiesPath);
		BufferedReader br =null;
		try {
			Configuration conf = new Configuration();
			FileSystem fs = FileSystem.get(conf);
			Path path = new Path(hdfsPropertiesPath);
			FSDataInputStream fsDataInputStream = fs.open(path);
			br = new BufferedReader(new InputStreamReader(fsDataInputStream));
			String line = null;
			while ((line = br.readLine()) != null) {
				if(line.contains("=") && !line.trim().startsWith("#")){
					//只替换第一个"="号
					String rline =line.replaceFirst("="," ");
					propertiesMap.put(rline.split(" ")[0].trim(),rline.split(" ")[1].trim());
				}
			}
			//判断运行环境
			if("online".equals(propertiesMap.get("spark.model"))){
				System.out.println("propertiesMap:" + propertiesMap);
			}
		} catch (Exception e){
			e.printStackTrace();
		} finally {
			try {
				if (br !=null) {
					br.close();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

}

