package com.tmp

import org.apache.spark.rdd.RDD
import org.apache.spark.{SparkConf, SparkContext}
import org.apache.spark.sql.{DataFrame, SparkSession}

/**
  * 通过元组创建
  *
  * @Author zhenxin.ma
  * @Date 2020/3/20 10:40
  * @Version 1.0
  */
object SparkRow_2 {
    def main(args: Array[String]): Unit = {
        val conf: SparkConf = new SparkConf().setAppName("").setMaster("local[*]")
        val sparkSession: SparkSession = SparkSession.builder().config(conf).enableHiveSupport().getOrCreate()
        val sc: SparkContext = sparkSession.sparkContext

        val source: RDD[String] = sc.textFile("file:\\D:\\ideaworkspace\\label\\data\\ss.text")
        val personRDD: RDD[(Int, String, Int, Int)] = source.map(f => {
            val strs: Array[String] = f.split(",")
            (strs(0).toInt, strs(1), strs(2).toInt, strs(3).toInt)
        })


        import sparkSession.implicits._
        val df: DataFrame = personRDD.toDF("id","name","age","score")
        df.printSchema()
        df.show(5)
        sparkSession.close()
    }

}
