package com.tmp

import org.apache.spark.rdd.RDD
import org.apache.spark.sql.{DataFrame, SparkSession}
import org.apache.spark.{SparkConf, SparkContext}

/**
  * 把RDD[T]编程RDD[case class],使用隐式转换toDF()得到DataFrame
  * @Author     zhenxin.ma
  * @Date       2020/3/20 10:15
  * @Version    1.0
  */

case class Person( id:Int,  name:String,  age:Int, score:Int){

}


object SparkRow_1 {
    def main(args: Array[String]): Unit = {
        val conf: SparkConf = new SparkConf().setAppName("").setMaster("local[*]")
        val sparkSession: SparkSession = SparkSession.builder().config(conf).enableHiveSupport().getOrCreate()
        val sc: SparkContext = sparkSession.sparkContext

        val source: RDD[String] = sc.textFile("file:\\D:\\ideaworkspace\\label\\data\\ss.text")
        val personRDD: RDD[Person] = source.map(f => {
            val strs: Array[String] = f.split(",")
            Person(strs(0).toInt, strs(1), strs(2).toInt, strs(3).toInt)
        })

        import sparkSession.implicits._
        val df: DataFrame = personRDD.toDF()
        df.printSchema()
        df.show(5)
        sparkSession.close()
    }
}
