package com.common

import java.text.SimpleDateFormat
import java.util.{Calendar, Date}


/**
  * created by yunfeng.wu@picahealth.com on 2019/07/30
  */
object DateUtil extends Serializable {
  val yyyyMMdd = "yyyyMMdd"

  def year_month_day(yyyymmdd: String) = {
    val sdf = new SimpleDateFormat("yyyyMMdd")
    sdf.parse(yyyymmdd)
  }

  def year_month_day(time: Date) = {
    val sdf = new SimpleDateFormat("yyyyMMdd")
    sdf.format(time)
  }

  def nextDay(current: Date) = {
    val c = Calendar.getInstance
    c.setTime(current)
    c.add(Calendar.DAY_OF_MONTH, 1)
    c.getTime
  }

  /**
    * 根据日期获取当前日期所属季度
    *
    * @param date
    * @return
    */
  def getCurrentSeasonByDate(date: Date): String = {
    var season = 0
    val c = Calendar.getInstance
    c.setTime(date)
    val month = c.get(Calendar.MONTH)
    month match {
      case Calendar.JANUARY =>
      case Calendar.FEBRUARY =>
      case Calendar.MARCH =>
        season = 1
      case Calendar.APRIL =>
      case Calendar.MAY =>
      case Calendar.JUNE =>
        season = 2
      case Calendar.JULY =>
      case Calendar.AUGUST =>
      case Calendar.SEPTEMBER =>
        season = 3
      case Calendar.OCTOBER =>
      case Calendar.NOVEMBER =>
      case Calendar.DECEMBER =>
        season = 4
    }
    return String.valueOf(season)
  }
  //计算两个日期之间的天数
  def getBetweenDays(endDate: Long, beginDate: Long): Long = {
    val cal = Calendar.getInstance()
    cal.setTime(new Date(endDate));
    val end = cal.getTimeInMillis()
    cal.setTime(new Date(beginDate));
    val begin = cal.getTimeInMillis()
    val between_days = (end - begin) / (1000 * 3600 * 24)
    between_days
  }

  import java.util.Calendar

  /**
    * 获取两个日期相差的月数
    *
    * @param d1 较大的日期
    * @param d2 较小的日期
    * @return 如果d1>d2返回 月数差 否则返回0
    */
  def getMonthDiff(d1: Date, d2: Date): Int = {
    val c1 = Calendar.getInstance
    val c2 = Calendar.getInstance
    c1.setTime(d1)
    c2.setTime(d2)
    if (c1.getTimeInMillis < c2.getTimeInMillis) return 0
    val year1 = c1.get(Calendar.YEAR)
    val year2 = c2.get(Calendar.YEAR)
    val month1 = c1.get(Calendar.MONTH)
    val month2 = c2.get(Calendar.MONTH)
    val day1 = c1.get(Calendar.DAY_OF_MONTH)
    val day2 = c2.get(Calendar.DAY_OF_MONTH)
    // 获取年的差值 假设 d1 = 2015-8-16  d2 = 2011-9-30
    var yearInterval = year1 - year2
    // 如果 d1的 月-日 小于 d2的 月-日 那么 yearInterval-- 这样就得到了相差的年数
    if (month1 < month2 || month1 == month2 && day1 < day2) {
      yearInterval -= 1; yearInterval + 1
    }
    // 获取月数差值
    var monthInterval = (month1 + 12) - month2
    if (day1 < day2) {
      monthInterval -= 1; monthInterval + 1
    }
    monthInterval %= 12
    yearInterval * 12 + monthInterval
  }
  //获取日期时间字符串(yyyy-MM-dd HH:mm:ss)前后x天的时间
  def beforeDay(dateTime: String, days: Int) = {
    val date = Calendar.getInstance()
    date.setTime(new Date(dateToLong(dateTime, yyyyMMdd)))
    date.set(Calendar.DATE, date.get(Calendar.DATE) - days)
    date.getTime().getTime
  }

  //得到前x天的时间
  def beforeNowXDayTime(days: Int) = {
    val date = Calendar.getInstance()
    date.setTime(new Date())
    date.set(Calendar.DATE, date.get(Calendar.DATE) - days)
    date.getTime().getTime
  }

  //得到x年前的时间
  def beforeNowXYearTime(year: Int) = {
    val date = Calendar.getInstance()
    date.setTime(new Date())
    date.add(Calendar.YEAR, -year)
    date.getTime().getTime
  }

  //得到前x个月的时间
  def beforeNowXMonthTime(month: Int) = {
    val date = Calendar.getInstance()
    date.setTime(new Date())
    date.add(Calendar.MONTH, -month)
    date.getTime().getTime
  }

  //获取本月的第一天
  def getNowMonthStart(): String = {
    var period: String = ""
    val cal: Calendar = Calendar.getInstance();
    val df: SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    cal.set(Calendar.DATE, 1)
    period = df.format(cal.getTime()) //本月第一天
    period
  }

  def dateToLong(dateTime: String, format2: String) = {
    val sdf = new SimpleDateFormat(format2)
    sdf.parse(dateTime).getTime
  }

  def longToString(t: Long, format: String) = {
    val sdf = new SimpleDateFormat(format)
    val d = new Date(t)
    sdf.format(d)
  }
}

