package com.session

import org.apache.hadoop.conf.Configuration
import org.apache.hadoop.fs.{FileSystem, Path}

/**
  * 自动删除存在的HDFS目录
  * @Author zhenxin.ma
  * @Date 	2019/9/4 20:42
  * @Version 1.0
  */
class DeletePath(val outpath:String) {
	def deletePath:Unit = {
		//Hadoop的配置
		val conf: Configuration = new Configuration()
		//获取Hadoop的文件系统
		val fs: FileSystem = FileSystem.get(conf)
		//构造Path对象
		val path: Path = new Path(outpath)
		if (fs.exists(path)){
			fs.delete(path,true)
			println(s"delete ${outpath} success!")
		}
	}
}
