package com.utils

import java.sql
import java.sql.{Connection, DriverManager, PreparedStatement, ResultSet}

import com.config.MySQLConfig


/**
  * 连接 MySQL的工具类
  *
  * @Author zhenxin.ma
  * @Date 	2019/8/12 13:47
  * @Version 1.0
  */
object JDBCUtil {
	/**
	  * @Description 获取JDBC链接MYSQL
	  * @return java.sql.Connection
	  **/
	def getConnection():Connection = {
		var con: Connection = null
		try{
			Class.forName(MySQLConfig.HDFS_DRIVER)
			con = DriverManager.getConnection(MySQLConfig.HDFS_URL, MySQLConfig.HDFS_USERNAME, MySQLConfig.HDFS_PSSWORD)
		} catch {
			case e:Exception => {
				println("-----------MYSQL Connection has exception , msg = "+ e.getMessage())
			}
		}
		con
	}


	/**
	 * @Description 获取结果集
	 * @param sql	执行的SQL
	 * @param jobName	要分析的表任务名字
	 * @param sync	批次号
	 * @return java.sql.ResultSet
	 **/
	def getResultSet(sql: String, jobName:String, sync:String):ResultSet = {
		var resultSet: ResultSet = null
		var prest:PreparedStatement = null
		try{
			val con: Connection = getConnection()
			prest = con.prepareStatement(sql)
			prest.setString(1, jobName)
			prest.setString(2, sync)
			resultSet = prest.executeQuery()
			resultSet
		}catch {
			case e: Exception => e.printStackTrace()
				resultSet
		}
	}


	/**
	  * @Description 关闭连接和释放资源
	  * @return void
	  **/
	def close(con: Connection,prest:PreparedStatement): Unit = {
		try{
			if (prest != null) {
				prest.close()
			}
			if (con != null) {
				con.close()
			}
			println("------关闭MYSQL连接和释放资源------")
		}catch {
			case e: Exception => e.printStackTrace()
		}
	}

	//往配置记录表 record插入数据
	def insertRecord(connSql: sql.Connection, sq: String ,array:Array[String]): Int = {
		val preState: PreparedStatement = connSql.prepareStatement(sq)
		for (i <-0 until array.length) {
			preState.setString(i + 1,array(i))
		}
		val flag: Int = preState.executeUpdate()
		preState.close()
		flag
	}


}
