package com;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @Author 	zhenxin.ma
 * @Date 	2019/8/29 17:28
 * @Version 1.0
 */
public class DateUtils {
	public static ThreadLocal<SimpleDateFormat> simpleDateFormatThreadLocal=new ThreadLocal<SimpleDateFormat>(){
		@Override
		protected SimpleDateFormat initialValue() {
			return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		}
	};

	/**
	 * @Description 毫秒转换成标准时间 yyyy-MM-dd HH:mm:ss
	 * @param time
	 * @return java.lang.String
	 **/
	public static String milliSecondsFormatTime(String time){
		Date tmpDate = new Date();
		tmpDate.setTime(Long.parseLong(time));
		String dtime = simpleDateFormatThreadLocal.get().format(tmpDate);
		return dtime;
	}

	//获取今天的时间
	public static String getTodayDate() {
		return simpleDateFormatThreadLocal.get().format(new Date());
	}

	//获取昨天的日期:yyyy-MM-dd
	public static String getYesterdayTime(int gapDay){
		Calendar calendar=Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY,24*gapDay);
		String yesterdayDate=simpleDateFormatThreadLocal.get().format(calendar.getTime());
		return  yesterdayDate;
	}

	public static void main(String[] args) {
		final String time = getYesterdayTime(-1);
		System.out.println(time);
		final String s = time.split(" ")[0];
		System.out.println(s);
		System.out.println(s.replace("-", ""));
		System.out.println(getTodayDate());

	}

}

